/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans;

import com.googlecode.jmxtrans.OutputWriter;
import com.googlecode.jmxtrans.jobs.ServerJob;
import com.googlecode.jmxtrans.model.JmxProcess;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.util.JmxUtils;
import com.googlecode.jmxtrans.util.LifecycleException;
import com.googlecode.jmxtrans.util.OptionsException;
import com.googlecode.jmxtrans.util.SignalInterceptor;
import com.googlecode.jmxtrans.util.ValidationException;
import com.googlecode.jmxtrans.util.WatchDir;
import com.googlecode.jmxtrans.util.WatchedCallback;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.pool.KeyedObjectPool;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.quartz.CronExpression;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxTransformer
extends SignalInterceptor
implements WatchedCallback {
    private static final Logger log = LoggerFactory.getLogger(JmxTransformer.class);
    private static String QUARTZ_SERVER_PROPERTIES = null;
    private static int SECONDS_BETWEEN_SERVER_JOB_RUNS = 60;
    private File jsonDirOrFile;
    private boolean runEndlessly;
    private Scheduler serverScheduler;
    private WatchDir watcher;
    private Map<String, KeyedObjectPool> poolMap;
    private List<Server> masterServersList = new ArrayList<Server>();

    public static void main(String[] args) throws Exception {
        JmxTransformer transformer = new JmxTransformer();
        transformer.registerQuietly("HUP");
        transformer.registerQuietly("INT");
        transformer.registerQuietly("ABRT");
        transformer.registerQuietly("KILL");
        transformer.registerQuietly("TERM");
        transformer.doMain(args);
    }

    private void doMain(String[] args) throws Exception {
        if (!this.parseOptions(args)) {
            return;
        }
        try {
            this.startupScheduler();
            this.startupWatchdir();
            this.setupObjectPooling();
            this.startupSystem();
        }
        catch (Exception e) {
            this.runEndlessly = false;
            log.error(e.getMessage(), e.getCause());
        }
        if (!this.runEndlessly) {
            this.handle("TERM");
        }
    }

    private void startupWatchdir() throws Exception {
        File dirToWatch = null;
        dirToWatch = this.getJsonDirOrFile().isFile() ? new File(FilenameUtils.getFullPath((String)this.getJsonDirOrFile().getAbsolutePath())) : this.getJsonDirOrFile();
        this.watcher = new WatchDir(dirToWatch, this);
        this.watcher.start();
    }

    private void startupScheduler() throws Exception {
        StdSchedulerFactory serverSchedFact = new StdSchedulerFactory();
        InputStream stream = null;
        if (QUARTZ_SERVER_PROPERTIES == null) {
            QUARTZ_SERVER_PROPERTIES = "/quartz.server.properties";
            stream = JmxTransformer.class.getResourceAsStream(QUARTZ_SERVER_PROPERTIES);
        } else {
            stream = new FileInputStream(QUARTZ_SERVER_PROPERTIES);
        }
        serverSchedFact.initialize(stream);
        this.serverScheduler = serverSchedFact.getScheduler();
        this.serverScheduler.start();
    }

    public void executeStandalone(JmxProcess process) throws Exception {
        this.masterServersList = process.getServers();
        this.startupScheduler();
        this.setupObjectPooling();
        this.processServersIntoJobs(this.serverScheduler);
        Thread.sleep(10000L);
        this.handle("TERM");
    }

    private void startupSystem() throws LifecycleException {
        this.processFilesIntoServers(this.getJsonFiles());
        this.processServersIntoJobs(this.serverScheduler);
    }

    protected void setupObjectPooling() {
        if (this.poolMap == null) {
            this.poolMap = JmxUtils.getDefaultPoolMap();
        }
    }

    @JsonIgnore
    public Map<String, KeyedObjectPool> getObjectPoolMap() {
        if (this.poolMap == null) {
            this.setupObjectPooling();
        }
        return this.poolMap;
    }

    private void validateSetup(List<Query> queries) throws ValidationException {
        for (Query q : queries) {
            this.validateSetup(q);
        }
    }

    private void validateSetup(Query query) throws ValidationException {
        List<OutputWriter> writers = query.getOutputWriters();
        if (writers != null) {
            for (OutputWriter w : writers) {
                w.validateSetup(query);
            }
        }
    }

    private void processFilesIntoServers(List<File> jsonFiles) throws LifecycleException {
        for (File jsonFile : jsonFiles) {
            try {
                JmxProcess process = JmxUtils.getJmxProcess(jsonFile);
                if (log.isDebugEnabled()) {
                    log.debug("Loaded file: " + jsonFile.getAbsolutePath());
                }
                JmxUtils.mergeServerLists(this.masterServersList, process.getServers());
            }
            catch (Exception ex) {
                throw new LifecycleException("Error parsing json: " + jsonFile, ex);
            }
        }
    }

    private void processServersIntoJobs(Scheduler scheduler) throws LifecycleException {
        for (Server server : this.masterServersList) {
            try {
                for (Query query : server.getQueries()) {
                    query.setServer(server);
                    for (OutputWriter writer : query.getOutputWriters()) {
                        writer.setObjectPoolMap(this.poolMap);
                        writer.start();
                    }
                }
                this.validateSetup(server.getQueries());
                this.scheduleJob(scheduler, server);
            }
            catch (ParseException ex) {
                throw new LifecycleException("Error parsing cron expression: " + server.getCronExpression(), ex);
            }
            catch (SchedulerException ex) {
                throw new LifecycleException("Error scheduling job for server: " + server, (Exception)((Object)ex));
            }
            catch (ValidationException ex) {
                throw new LifecycleException("Error validating json setup for query", ex);
            }
        }
    }

    private void scheduleJob(Scheduler scheduler, Server server) throws ParseException, SchedulerException {
        String name = server.getHost() + ":" + server.getPort() + "-" + System.currentTimeMillis();
        JobDetail jd = new JobDetail(name, "ServerJob", ServerJob.class);
        JobDataMap map = new JobDataMap();
        map.put((Object)Server.class.getName(), (Object)server);
        map.put((Object)Server.JMX_CONNECTION_FACTORY_POOL, (Object)this.getObjectPoolMap().get(Server.JMX_CONNECTION_FACTORY_POOL));
        jd.setJobDataMap(map);
        CronTrigger trigger = null;
        if (server.getCronExpression() != null && CronExpression.isValidExpression((String)server.getCronExpression())) {
            trigger = new CronTrigger();
            trigger.setCronExpression(server.getCronExpression());
            trigger.setName(server.getHost() + ":" + server.getPort() + "-" + Long.valueOf(System.currentTimeMillis()).toString());
            trigger.setStartTime(new Date());
        } else {
            Trigger minuteTrigger = TriggerUtils.makeSecondlyTrigger((int)SECONDS_BETWEEN_SERVER_JOB_RUNS);
            minuteTrigger.setName(server.getHost() + ":" + server.getPort() + "-" + Long.valueOf(System.currentTimeMillis()).toString());
            minuteTrigger.setStartTime(new Date());
            trigger = minuteTrigger;
        }
        scheduler.scheduleJob(jd, (Trigger)trigger);
        if (log.isDebugEnabled()) {
            log.debug("Scheduled job: " + jd.getName() + " for server: " + server);
        }
    }

    private void deleteAllJobs(Scheduler scheduler) throws Exception {
        String[] jobGroups;
        ArrayList<JobDetail> allJobs = new ArrayList<JobDetail>();
        for (String jobGroup : jobGroups = scheduler.getJobGroupNames()) {
            String[] jobNames;
            for (String jobName : jobNames = scheduler.getJobNames(jobGroup)) {
                allJobs.add(scheduler.getJobDetail(jobName, jobGroup));
            }
        }
        for (JobDetail jd : allJobs) {
            scheduler.deleteJob(jd.getName(), jd.getGroup());
            if (!log.isDebugEnabled()) continue;
            log.debug("Deleted scheduled job: " + jd.getName() + " group: " + jd.getGroup());
        }
    }

    public void setRunEndlessly(boolean runEndlessly) {
        this.runEndlessly = runEndlessly;
    }

    public boolean isRunEndlessly() {
        return this.runEndlessly;
    }

    private boolean parseOptions(String[] args) throws OptionsException, org.apache.commons.cli.ParseException {
        GnuParser parser = new GnuParser();
        CommandLine cl = parser.parse(this.getOptions(), args);
        Option[] options = cl.getOptions();
        boolean result = true;
        for (Option option : options) {
            File tmp;
            if (option.getOpt().equals("j")) {
                tmp = new File(option.getValue());
                if (!tmp.exists() && !tmp.isDirectory()) {
                    throw new OptionsException("Path to json directory is invalid: " + tmp);
                }
                this.setJsonDirOrFile(tmp);
                continue;
            }
            if (option.getOpt().equals("f")) {
                tmp = new File(option.getValue());
                if (!tmp.exists() && !tmp.isFile()) {
                    throw new OptionsException("Path to json file is invalid: " + tmp);
                }
                this.setJsonDirOrFile(tmp);
                continue;
            }
            if (option.getOpt().equals("e")) {
                this.setRunEndlessly(true);
                continue;
            }
            if (option.getOpt().equals("q")) {
                QUARTZ_SERVER_PROPERTIES = option.getValue();
                File file = new File(QUARTZ_SERVER_PROPERTIES);
                if (file.exists()) continue;
                throw new OptionsException("Could not find path to the quartz properties file: " + file.getAbsolutePath());
            }
            if (option.getOpt().equals("s")) {
                SECONDS_BETWEEN_SERVER_JOB_RUNS = Integer.valueOf(option.getValue());
                continue;
            }
            if (!option.getOpt().equals("h")) continue;
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java -jar jmxtrans-all.jar", this.getOptions());
            result = false;
        }
        if (result && this.getJsonDirOrFile() == null) {
            throw new OptionsException("Please specify either the -f or -j option.");
        }
        return result;
    }

    public Options getOptions() {
        Options options = new Options();
        options.addOption("j", true, "Directory where json configuration is stored. Default is .");
        options.addOption("f", true, "A single json file to execute.");
        options.addOption("e", false, "Run endlessly. Default false.");
        options.addOption("q", true, "Path to quartz configuration file.");
        options.addOption("s", true, "Seconds between server job runs (not defined with cron). Default: 60");
        options.addOption("h", false, "Help");
        return options;
    }

    public void setJsonDirOrFile(File jsonDirOrFile) {
        this.jsonDirOrFile = jsonDirOrFile;
    }

    public File getJsonDirOrFile() {
        return this.jsonDirOrFile;
    }

    private List<File> getJsonFiles() {
        File[] files = null;
        files = this.getJsonDirOrFile() != null && this.getJsonDirOrFile().isFile() ? new File[]{this.getJsonDirOrFile()} : this.getJsonDirOrFile().listFiles();
        ArrayList<File> result = new ArrayList<File>();
        for (File file : files) {
            if (!this.isJsonFile(file)) continue;
            result.add(file);
        }
        return result;
    }

    @Override
    protected boolean handle(String signame) {
        if (log.isDebugEnabled()) {
            log.debug("Got signame: " + signame);
        }
        try {
            if (this.serverScheduler != null) {
                this.serverScheduler.shutdown(true);
                log.debug("Shutdown server scheduler");
            }
            if (this.watcher != null) {
                this.watcher.stopService();
                log.debug("Shutdown watch service");
            }
            for (Map.Entry<String, KeyedObjectPool> entry : this.getObjectPoolMap().entrySet()) {
                try {
                    entry.getValue().close();
                    log.debug("Closed object pool factory: " + entry.getKey());
                }
                catch (Exception ex) {
                    log.error("Error closing object pool factory: " + entry.getKey());
                }
            }
            for (Server server : this.masterServersList) {
                for (Query query : server.getQueries()) {
                    for (OutputWriter writer : query.getOutputWriters()) {
                        try {
                            writer.stop();
                            log.debug("Stopped writer: " + writer.getClass().getSimpleName() + " for query: " + query);
                        }
                        catch (LifecycleException ex) {
                            log.error("Error stopping writer: " + writer.getClass().getSimpleName() + " for query: " + query);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private boolean isJsonFile(File file) {
        if (this.getJsonDirOrFile().isFile()) {
            return file.equals(this.getJsonDirOrFile());
        }
        return file.isFile() && file.getName().endsWith(".json");
    }

    @Override
    public void fileModified(File file) throws Exception {
        if (this.isJsonFile(file)) {
            Thread.sleep(1000L);
            if (log.isDebugEnabled()) {
                log.debug("File modified: " + file);
            }
            this.deleteAllJobs(this.serverScheduler);
            this.startupSystem();
        }
    }

    @Override
    public void fileDeleted(File file) throws Exception {
        if (this.isJsonFile(file)) {
            Thread.sleep(1000L);
            if (log.isDebugEnabled()) {
                log.debug("File deleted: " + file);
            }
            this.deleteAllJobs(this.serverScheduler);
            this.startupSystem();
        }
    }

    @Override
    public void fileAdded(File file) throws Exception {
        if (this.isJsonFile(file)) {
            Thread.sleep(1000L);
            if (log.isDebugEnabled()) {
                log.debug("File added: " + file);
            }
            this.startupSystem();
        }
    }
}

