/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Executor;
import org.fusesource.hawtdispatch.Dispatch;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.DispatchSource;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.TaskWrapper;
import org.fusesource.hawtdispatch.transport.TcpTransport;
import org.fusesource.hawtdispatch.transport.TransportServer;
import org.fusesource.hawtdispatch.transport.TransportServerListener;

public class TcpTransportServer
implements TransportServer {
    protected final String bindScheme;
    protected final InetSocketAddress bindAddress;
    protected int backlog = 100;
    protected ServerSocketChannel channel;
    protected TransportServerListener listener;
    protected DispatchQueue dispatchQueue;
    protected DispatchSource acceptSource;
    protected int receiveBufferSize = 65536;
    protected int sendBufferSize = 77056;
    protected Executor blockingExecutor;

    public TcpTransportServer(URI location) throws UnknownHostException {
        this.bindScheme = location.getScheme();
        String host = location.getHost();
        host = host == null || host.length() == 0 ? "::" : host;
        this.bindAddress = new InetSocketAddress(InetAddress.getByName(host), location.getPort());
    }

    public void setTransportServerListener(TransportServerListener listener) {
        this.listener = listener;
    }

    public InetSocketAddress getSocketAddress() {
        return (InetSocketAddress)this.channel.socket().getLocalSocketAddress();
    }

    public DispatchQueue getDispatchQueue() {
        return this.dispatchQueue;
    }

    public void setDispatchQueue(DispatchQueue dispatchQueue) {
        this.dispatchQueue = dispatchQueue;
    }

    public void suspend() {
        this.acceptSource.suspend();
    }

    public void resume() {
        this.acceptSource.resume();
    }

    @Deprecated
    public void start(Runnable onCompleted) throws Exception {
        this.start((Task)new TaskWrapper(onCompleted));
    }

    @Deprecated
    public void stop(Runnable onCompleted) throws Exception {
        this.stop((Task)new TaskWrapper(onCompleted));
    }

    public void start(Task onCompleted) throws Exception {
        try {
            this.channel = ServerSocketChannel.open();
            this.channel.configureBlocking(false);
            try {
                this.channel.socket().setReceiveBufferSize(this.receiveBufferSize);
            }
            catch (SocketException ignore) {
                // empty catch block
            }
            try {
                this.channel.socket().setReceiveBufferSize(this.sendBufferSize);
            }
            catch (SocketException ignore) {
                // empty catch block
            }
            this.channel.socket().bind(this.bindAddress, this.backlog);
        }
        catch (IOException e) {
            throw new IOException("Failed to bind to server socket: " + this.bindAddress + " due to: " + e);
        }
        this.acceptSource = Dispatch.createSource((SelectableChannel)this.channel, (int)16, (DispatchQueue)this.dispatchQueue);
        this.acceptSource.setEventHandler(new Task(){

            public void run() {
                try {
                    SocketChannel client = TcpTransportServer.this.channel.accept();
                    while (client != null) {
                        TcpTransportServer.this.handleSocket(client);
                        client = TcpTransportServer.this.channel.accept();
                    }
                }
                catch (Exception e) {
                    TcpTransportServer.this.listener.onAcceptError(e);
                }
            }
        });
        this.acceptSource.setCancelHandler(new Task(){

            public void run() {
                try {
                    TcpTransportServer.this.channel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.acceptSource.resume();
        if (onCompleted != null) {
            this.dispatchQueue.execute(onCompleted);
        }
    }

    public String getBoundAddress() {
        try {
            return new URI(this.bindScheme, null, this.bindAddress.getAddress().getHostAddress(), this.channel.socket().getLocalPort(), null, null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop(final Task onCompleted) throws Exception {
        if (this.acceptSource.isCanceled()) {
            onCompleted.run();
        } else {
            this.acceptSource.setCancelHandler(new Task(){

                public void run() {
                    try {
                        TcpTransportServer.this.channel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    onCompleted.run();
                }
            });
            this.acceptSource.cancel();
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    protected final void handleSocket(SocketChannel socket) throws Exception {
        TcpTransport transport = this.createTransport();
        transport.connected(socket);
        this.listener.onAccept(transport);
    }

    protected TcpTransport createTransport() {
        TcpTransport rc = new TcpTransport();
        rc.setBlockingExecutor(this.blockingExecutor);
        rc.setDispatchQueue(this.dispatchQueue);
        return rc;
    }

    public String toString() {
        return this.getBoundAddress();
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
        if (this.channel != null) {
            try {
                this.channel.socket().setReceiveBufferSize(receiveBufferSize);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
        if (this.channel != null) {
            try {
                this.channel.socket().setReceiveBufferSize(sendBufferSize);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    public Executor getBlockingExecutor() {
        return this.blockingExecutor;
    }

    public void setBlockingExecutor(Executor blockingExecutor) {
        this.blockingExecutor = blockingExecutor;
    }
}

