/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.virt.service;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.libvirt.Connect;
import org.libvirt.LibvirtException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibvirtServiceFactory
implements ManagedServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LibvirtServiceFactory.class);
    public static final String URL = "url";
    private final Map<String, ServiceRegistration> registrations = new ConcurrentHashMap<String, ServiceRegistration>();
    private final BundleContext bundleContext;

    public LibvirtServiceFactory(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public String getName() {
        return "LibVirt Service Factory";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        ServiceRegistration oldRegistration;
        ServiceRegistration newRegistration = null;
        try {
            if (properties != null) {
                Properties props = new Properties();
                Enumeration e = properties.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    Object val = properties.get(key);
                    props.put(key, val);
                }
                String url = (String)properties.get(URL);
                try {
                    Connect connect = new Connect(url, false);
                    newRegistration = this.bundleContext.registerService(Connect.class.getName(), (Object)connect, properties);
                }
                catch (LibvirtException e2) {
                    LOG.error("Error creating libvirt connection", (Throwable)e2);
                }
            }
            ServiceRegistration serviceRegistration = oldRegistration = newRegistration == null ? this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
        }
        catch (Throwable throwable) {
            ServiceRegistration oldRegistration2;
            ServiceRegistration serviceRegistration = oldRegistration2 = newRegistration == null ? this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
            if (oldRegistration2 != null) {
                System.out.println("Unregistering libvirt connection " + pid);
                oldRegistration2.unregister();
            }
            throw throwable;
        }
        if (oldRegistration != null) {
            System.out.println("Unregistering libvirt connection " + pid);
            oldRegistration.unregister();
        }
    }

    public void deleted(String pid) {
        ServiceRegistration oldRegistration = this.registrations.remove(pid);
        if (this.bundleContext != null) {
            Connect connect = (Connect)this.bundleContext.getService(oldRegistration.getReference());
            try {
                connect.close();
            }
            catch (LibvirtException e) {
                LOG.error("Error closing libvirt connection", (Throwable)e);
            }
        }
        if (oldRegistration != null) {
            oldRegistration.unregister();
        }
    }
}

