/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.virt.commands;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.fusesource.fabric.virt.commands.LibvirtCommandSupport;

@Command(scope="virt", name="domain-define")
public class DefineDomain
extends LibvirtCommandSupport {
    @Argument(name="descriptorUri", description="A URI to a domain descriptor", required=true, multiValued=false)
    private String descriptorUri;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doExecute() throws Exception {
        URI uri = new URI(this.descriptorUri);
        InputStream is = null;
        BufferedReader reader = null;
        try {
            is = uri.toURL().openStream();
            reader = new BufferedReader(new InputStreamReader(is));
            StringBuilder builder = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                builder.append(line);
                line = reader.readLine();
            }
            String descriptor = builder.toString();
            this.getConnection().domainDefineXML(descriptor);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return null;
    }
}

