/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.network.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.domain.network.Features;
import org.jclouds.vcloud.domain.network.FenceMode;
import org.jclouds.vcloud.domain.network.IpScope;
import org.jclouds.vcloud.domain.network.OrgNetwork;

public class OrgNetworkImpl
extends ReferenceTypeImpl
implements OrgNetwork {
    @Nullable
    private final ReferenceType org;
    @Nullable
    private final String description;
    private final List<Task> tasks = Lists.newArrayList();
    private final OrgNetwork.Configuration configuration;
    @Nullable
    private final ReferenceType networkPool;
    private final Set<String> allowedExternalIpAddresses = Sets.newLinkedHashSet();

    public OrgNetworkImpl(String name, String type, URI id, @Nullable ReferenceType org, @Nullable String description, Iterable<Task> tasks, OrgNetwork.Configuration configuration, @Nullable ReferenceType networkPool, Iterable<String> allowedExternalIpAddresses) {
        super(name, type, id);
        this.org = org;
        this.description = description;
        Iterables.addAll(this.tasks, Preconditions.checkNotNull(tasks, "tasks"));
        this.configuration = Preconditions.checkNotNull(configuration, "configuration");
        this.networkPool = networkPool;
        Iterables.addAll(this.allowedExternalIpAddresses, Preconditions.checkNotNull(allowedExternalIpAddresses, "allowedExternalIpAddresses"));
    }

    @Override
    public ReferenceType getOrg() {
        return this.org;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<Task> getTasks() {
        return this.tasks;
    }

    @Override
    public OrgNetwork.Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public ReferenceType getNetworkPool() {
        return this.networkPool;
    }

    @Override
    public Set<String> getAllowedExternalIpAddresses() {
        return this.allowedExternalIpAddresses;
    }

    @Override
    public Objects.ToStringHelper string() {
        Objects.ToStringHelper helper = super.string().add("org", this.org).add("description", this.description).add("configuration", this.configuration).add("networkPool", this.networkPool);
        if (this.allowedExternalIpAddresses.size() > 0) {
            helper.add("allowedExternalIpAddresses", this.allowedExternalIpAddresses);
        }
        if (this.tasks.size() > 0) {
            helper.add("tasks", this.tasks);
        }
        return helper;
    }

    public static class ConfigurationImpl
    implements OrgNetwork.Configuration {
        @Nullable
        private final IpScope ipScope;
        @Nullable
        private final ReferenceType parentNetwork;
        private final FenceMode fenceMode;
        private final Features features;

        public ConfigurationImpl(@Nullable IpScope ipScope, @Nullable ReferenceType parentNetwork, FenceMode fenceMode, @Nullable Features features) {
            this.ipScope = ipScope;
            this.parentNetwork = parentNetwork;
            this.fenceMode = Preconditions.checkNotNull(fenceMode, "fenceMode");
            this.features = features;
        }

        @Override
        public IpScope getIpScope() {
            return this.ipScope;
        }

        @Override
        public ReferenceType getParentNetwork() {
            return this.parentNetwork;
        }

        @Override
        public FenceMode getFenceMode() {
            return this.fenceMode;
        }

        @Override
        @Nullable
        public Features getFeatures() {
            return this.features;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigurationImpl that = (ConfigurationImpl)ConfigurationImpl.class.cast(o);
            return Objects.equal(this.ipScope, that.ipScope) && Objects.equal(this.parentNetwork, that.parentNetwork) && Objects.equal((Object)this.fenceMode, (Object)that.fenceMode) && Objects.equal(this.features, that.features);
        }

        public int hashCode() {
            return Objects.hashCode(new Object[]{this.ipScope, this.parentNetwork, this.fenceMode, this.features});
        }

        public String toString() {
            return Objects.toStringHelper("").omitNullValues().add("ipScope", this.ipScope).add("parentNetwork", this.parentNetwork).add("fenceMode", (Object)this.fenceMode).add("features", this.features).toString();
        }
    }
}

