/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.config.ValueOfConfigurationKeyOrNull;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.endpoints.Catalog;
import org.jclouds.vcloud.suppliers.OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault;

@Singleton
public class DefaultCatalogForOrg
implements Function<ReferenceType, ReferenceType> {
    private final OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault selector;
    private final Supplier<Map<String, Org>> nameToOrg;

    @Inject
    public DefaultCatalogForOrg(ValueOfConfigurationKeyOrNull valueOfConfigurationKeyOrNull, @Catalog Predicate<ReferenceType> defaultSelector, Supplier<Map<String, Org>> nameToOrg) {
        this.selector = new OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault(Preconditions.checkNotNull(valueOfConfigurationKeyOrNull, "valueOfConfigurationKeyOrNull"), "jclouds.vcloud.defaults.catalog", Preconditions.checkNotNull(defaultSelector, "defaultSelector"));
        this.nameToOrg = Preconditions.checkNotNull(nameToOrg, "nameToOrg");
    }

    @Override
    public ReferenceType apply(ReferenceType defaultOrg) {
        Org org = this.nameToOrg.get().get(defaultOrg.getName());
        Preconditions.checkState(org != null, "could not retrieve Org at %s", defaultOrg);
        return this.selector.apply((Iterable<ReferenceType>)org.getCatalogs().values());
    }
}

