/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.config;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.location.suppliers.ImplicitLocationSupplier;
import org.jclouds.location.suppliers.LocationsSupplier;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.config.BinderUtils;
import org.jclouds.rest.config.RestClientModule;
import org.jclouds.rest.suppliers.MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudClient;
import org.jclouds.trmk.vcloud_0_8.VCloudToken;
import org.jclouds.trmk.vcloud_0_8.compute.functions.FindLocationForResource;
import org.jclouds.trmk.vcloud_0_8.config.DefaultVCloudReferencesModule;
import org.jclouds.trmk.vcloud_0_8.domain.Catalog;
import org.jclouds.trmk.vcloud_0_8.domain.CatalogItem;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.VAppTemplate;
import org.jclouds.trmk.vcloud_0_8.domain.VCloudSession;
import org.jclouds.trmk.vcloud_0_8.domain.VDC;
import org.jclouds.trmk.vcloud_0_8.endpoints.Keys;
import org.jclouds.trmk.vcloud_0_8.endpoints.Org;
import org.jclouds.trmk.vcloud_0_8.endpoints.OrgList;
import org.jclouds.trmk.vcloud_0_8.endpoints.VCloudLogin;
import org.jclouds.trmk.vcloud_0_8.functions.AllCatalogItemsInCatalog;
import org.jclouds.trmk.vcloud_0_8.functions.AllCatalogItemsInOrg;
import org.jclouds.trmk.vcloud_0_8.functions.AllCatalogsInOrg;
import org.jclouds.trmk.vcloud_0_8.functions.AllVDCsInOrg;
import org.jclouds.trmk.vcloud_0_8.functions.OrgsForLocations;
import org.jclouds.trmk.vcloud_0_8.functions.OrgsForNames;
import org.jclouds.trmk.vcloud_0_8.functions.VAppTemplatesForCatalogItems;
import org.jclouds.trmk.vcloud_0_8.handlers.ParseTerremarkVCloudErrorFromHttpResponse;
import org.jclouds.trmk.vcloud_0_8.internal.TerremarkVCloudLoginAsyncClient;
import org.jclouds.trmk.vcloud_0_8.internal.TerremarkVCloudLoginClient;
import org.jclouds.trmk.vcloud_0_8.internal.TerremarkVCloudVersionsAsyncClient;
import org.jclouds.trmk.vcloud_0_8.internal.TerremarkVCloudVersionsClient;
import org.jclouds.trmk.vcloud_0_8.location.DefaultVDC;
import org.jclouds.trmk.vcloud_0_8.location.OrgAndVDCToLocationSupplier;
import org.jclouds.trmk.vcloud_0_8.predicates.TaskSuccess;
import org.jclouds.util.Strings2;
import org.jclouds.util.Suppliers2;

public class TerremarkVCloudRestClientModule<S, A>
extends RestClientModule<S, A> {
    static final Function<ReferenceType, String> name = new Function<ReferenceType, String>(){

        @Override
        public String apply(ReferenceType from) {
            return from.getName();
        }
    };

    public TerremarkVCloudRestClientModule() {
    }

    public TerremarkVCloudRestClientModule(Map<Class<?>, Class<?>> delegateMap) {
        super(delegateMap);
    }

    @Override
    protected void configure() {
        super.configure();
        this.bind(new TypeLiteral<Function<Iterable<? extends CatalogItem>, Iterable<? extends VAppTemplate>>>(){}).to((TypeLiteral<Function<Iterable<? extends CatalogItem>, Iterable<? extends VAppTemplate>>>)new TypeLiteral<VAppTemplatesForCatalogItems>(){});
        this.installDefaultVCloudEndpointsModule();
        this.bind(new TypeLiteral<Function<ReferenceType, Location>>(){}).to((TypeLiteral<Function<ReferenceType, Location>>)new TypeLiteral<FindLocationForResource>(){});
        this.bind(new TypeLiteral<Function<org.jclouds.trmk.vcloud_0_8.domain.Org, Iterable<? extends Catalog>>>(){}).to((TypeLiteral<Function<org.jclouds.trmk.vcloud_0_8.domain.Org, Iterable<? extends Catalog>>>)new TypeLiteral<AllCatalogsInOrg>(){});
        this.bind(new TypeLiteral<Function<org.jclouds.trmk.vcloud_0_8.domain.Org, Iterable<? extends VDC>>>(){}).to((TypeLiteral<Function<org.jclouds.trmk.vcloud_0_8.domain.Org, Iterable<? extends VDC>>>)new TypeLiteral<AllVDCsInOrg>(){});
        this.bind(new TypeLiteral<Function<Iterable<String>, Iterable<? extends org.jclouds.trmk.vcloud_0_8.domain.Org>>>(){}).to((TypeLiteral<Function<Iterable<String>, Iterable<? extends org.jclouds.trmk.vcloud_0_8.domain.Org>>>)new TypeLiteral<OrgsForNames>(){});
        this.bind(new TypeLiteral<Function<Iterable<? extends Location>, Iterable<? extends org.jclouds.trmk.vcloud_0_8.domain.Org>>>(){}).to((TypeLiteral<Function<Iterable<? extends Location>, Iterable<? extends org.jclouds.trmk.vcloud_0_8.domain.Org>>>)new TypeLiteral<OrgsForLocations>(){});
        this.bind(new TypeLiteral<Function<Catalog, Iterable<? extends CatalogItem>>>(){}).to((TypeLiteral<Function<Catalog, Iterable<? extends CatalogItem>>>)new TypeLiteral<AllCatalogItemsInCatalog>(){});
        this.bind(new TypeLiteral<Function<org.jclouds.trmk.vcloud_0_8.domain.Org, Iterable<? extends CatalogItem>>>(){}).to((TypeLiteral<Function<org.jclouds.trmk.vcloud_0_8.domain.Org, Iterable<? extends CatalogItem>>>)new TypeLiteral<AllCatalogItemsInOrg>(){});
        BinderUtils.bindClientAndAsyncClient(this.binder(), TerremarkVCloudVersionsClient.class, TerremarkVCloudVersionsAsyncClient.class);
        BinderUtils.bindClientAndAsyncClient(this.binder(), TerremarkVCloudLoginClient.class, TerremarkVCloudLoginAsyncClient.class);
    }

    @Provides
    @Singleton
    @org.jclouds.trmk.vcloud_0_8.endpoints.VDC
    protected Supplier<Map<String, String>> provideVDCtoORG(Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> orgNameToOrgSupplier) {
        return Suppliers2.compose(new Function<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>, Map<String, String>>(){

            @Override
            public Map<String, String> apply(Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org> arg0) {
                ImmutableMap.Builder<String, String> returnVal = ImmutableMap.builder();
                for (Map.Entry<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org> orgr : arg0.entrySet()) {
                    for (String vdc : orgr.getValue().getVDCs().keySet()) {
                        returnVal.put(vdc, orgr.getKey());
                    }
                }
                return returnVal.build();
            }
        }, orgNameToOrgSupplier);
    }

    @Provides
    @Singleton
    protected Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> provideOrgMapCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, OrgMapSupplier supplier) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, supplier, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @OrgList
    protected Supplier<URI> provideOrgListURI(Supplier<VCloudSession> sessionSupplier) {
        return Suppliers2.compose(new Function<VCloudSession, URI>(){

            @Override
            public URI apply(VCloudSession arg0) {
                return URI.create(Iterables.getLast(arg0.getOrgs().values()).getHref().toASCIIString().replaceAll("org/.*", "org"));
            }

            public String toString() {
                return "orgListURI()";
            }
        }, sessionSupplier);
    }

    protected void installDefaultVCloudEndpointsModule() {
        this.install(new DefaultVCloudReferencesModule());
    }

    @VCloudToken
    @Provides
    String provideVCloudToken(Supplier<VCloudSession> cache) {
        return Preconditions.checkNotNull(cache.get().getVCloudToken(), "No token present in session");
    }

    @Provides
    @Org
    @Singleton
    protected Supplier<Map<String, ReferenceType>> provideVDCtoORG(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, OrgNameToOrgSupplier supplier) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, supplier, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    protected Supplier<Map<URI, ? extends VDC>> provideURIToVDC(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, URItoVDC supplier) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, supplier, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @VCloudLogin
    protected Supplier<URI> provideAuthenticationURI(final TerremarkVCloudVersionsClient versionService, final @ApiVersion String version) {
        return new Supplier<URI>(){

            @Override
            public URI get() {
                SortedMap<String, URI> versions = versionService.getSupportedVersions();
                Preconditions.checkState(versions.size() > 0, "No versions present");
                Preconditions.checkState(versions.containsKey(version), "version " + version + " not present in: " + versions);
                return (URI)versions.get(version);
            }

            public String toString() {
                return "login()";
            }
        };
    }

    @Provides
    @Singleton
    protected Supplier<org.jclouds.trmk.vcloud_0_8.domain.Org> provideOrg(final Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> orgSupplier, @Org Supplier<ReferenceType> defaultOrg) {
        return Suppliers2.compose(new Function<ReferenceType, org.jclouds.trmk.vcloud_0_8.domain.Org>(){

            @Override
            public org.jclouds.trmk.vcloud_0_8.domain.Org apply(ReferenceType input) {
                return (org.jclouds.trmk.vcloud_0_8.domain.Org)((Map)orgSupplier.get()).get(input.getName());
            }
        }, defaultOrg);
    }

    @Provides
    @Singleton
    protected Predicate<URI> successTester(Injector injector, @Named(value="jclouds.vcloud.timeout.task-complete") long completed) {
        return new RetryablePredicate<URI>(injector.getInstance(TaskSuccess.class), completed);
    }

    @Provides
    @Singleton
    protected Supplier<Map<String, Map<String, ? extends Catalog>>> provideOrgCatalogItemMapSupplierCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, OrgCatalogSupplier supplier) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, supplier, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    protected Supplier<Map<String, Map<String, ? extends VDC>>> provideOrgVDCSupplierCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, OrgVDCSupplier supplier) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, supplier, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    protected Supplier<Map<String, Map<String, Map<String, ? extends CatalogItem>>>> provideOrgCatalogItemSupplierCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, OrgCatalogItemSupplier supplier) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, supplier, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Org
    Map<String, ReferenceType> listOrgs(Supplier<VCloudSession> sessionSupplier) {
        return sessionSupplier.get().getOrgs();
    }

    @Provides
    @Singleton
    protected Supplier<VCloudSession> provideVCloudTokenCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, final TerremarkVCloudLoginClient login) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, new Supplier<VCloudSession>(){

            @Override
            public VCloudSession get() {
                return login.login();
            }

            public String toString() {
                return Objects.toStringHelper(login).add("method", "login").toString();
            }
        }, seconds, TimeUnit.SECONDS);
    }

    @Singleton
    @Provides
    @Named(value="CreateInternetService")
    String provideCreateInternetService() throws IOException {
        return Strings2.toStringAndClose(this.getClass().getResourceAsStream("/CreateInternetService.xml"));
    }

    @Singleton
    @Provides
    @Named(value="CreateNodeService")
    String provideCreateNodeService() throws IOException {
        return Strings2.toStringAndClose(this.getClass().getResourceAsStream("/CreateNodeService.xml"));
    }

    @Override
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseTerremarkVCloudErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseTerremarkVCloudErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseTerremarkVCloudErrorFromHttpResponse.class);
    }

    @Provides
    @Singleton
    @Keys
    protected Supplier<Map<String, ReferenceType>> provideOrgToKeysListCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, OrgNameToKeysListSupplier supplier) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, supplier, seconds, TimeUnit.SECONDS);
    }

    @Singleton
    @Provides
    @Named(value="CreateKey")
    String provideCreateKey() throws IOException {
        return Strings2.toStringAndClose(this.getClass().getResourceAsStream("/CreateKey.xml"));
    }

    @Override
    protected void installLocations() {
        super.installLocations();
        this.bind(ImplicitLocationSupplier.class).to(DefaultVDC.class).in(Scopes.SINGLETON);
        this.bind(LocationsSupplier.class).to(OrgAndVDCToLocationSupplier.class).in(Scopes.SINGLETON);
    }

    @Singleton
    public static class OrgNameToKeysListSupplier
    implements Supplier<Map<String, ReferenceType>> {
        protected final Supplier<VCloudSession> sessionSupplier;
        private final TerremarkVCloudClient client;

        @Inject
        protected OrgNameToKeysListSupplier(Supplier<VCloudSession> sessionSupplier, TerremarkVCloudClient client) {
            this.sessionSupplier = sessionSupplier;
            this.client = client;
        }

        @Override
        public Map<String, ReferenceType> get() {
            return Maps.transformValues(this.sessionSupplier.get().getOrgs(), new Function<ReferenceType, ReferenceType>(){

                @Override
                public ReferenceType apply(ReferenceType from) {
                    return OrgNameToKeysListSupplier.this.client.findOrgNamed(from.getName()).getKeys();
                }
            });
        }
    }

    @Singleton
    public static class OrgCatalogItemSupplier
    implements Supplier<Map<String, Map<String, Map<String, ? extends CatalogItem>>>> {
        protected final Supplier<Map<String, Map<String, ? extends Catalog>>> catalogSupplier;
        protected final Function<Catalog, Iterable<? extends CatalogItem>> allCatalogItemsInCatalog;

        @Inject
        protected OrgCatalogItemSupplier(Supplier<Map<String, Map<String, ? extends Catalog>>> catalogSupplier, Function<Catalog, Iterable<? extends CatalogItem>> allCatalogItemsInCatalog) {
            this.catalogSupplier = catalogSupplier;
            this.allCatalogItemsInCatalog = allCatalogItemsInCatalog;
        }

        @Override
        public Map<String, Map<String, Map<String, ? extends CatalogItem>>> get() {
            return Maps.transformValues(this.catalogSupplier.get(), new Function<Map<String, ? extends Catalog>, Map<String, Map<String, ? extends CatalogItem>>>(){

                @Override
                public Map<String, Map<String, ? extends CatalogItem>> apply(Map<String, ? extends Catalog> from) {
                    return Maps.transformValues(from, new Function<Catalog, Map<String, ? extends CatalogItem>>(){

                        @Override
                        public Map<String, ? extends CatalogItem> apply(Catalog from) {
                            return Maps.uniqueIndex(OrgCatalogItemSupplier.this.allCatalogItemsInCatalog.apply(from), name);
                        }
                    });
                }
            });
        }
    }

    @Singleton
    public static class OrgVDCSupplier
    implements Supplier<Map<String, Map<String, ? extends VDC>>> {
        protected final Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> orgSupplier;
        private final Function<org.jclouds.trmk.vcloud_0_8.domain.Org, Iterable<? extends VDC>> allVDCsInOrg;

        @Inject
        protected OrgVDCSupplier(Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> orgSupplier, Function<org.jclouds.trmk.vcloud_0_8.domain.Org, Iterable<? extends VDC>> allVDCsInOrg) {
            this.orgSupplier = orgSupplier;
            this.allVDCsInOrg = allVDCsInOrg;
        }

        @Override
        public Map<String, Map<String, ? extends VDC>> get() {
            return Maps.transformValues(Maps.transformValues(this.orgSupplier.get(), this.allVDCsInOrg), new Function<Iterable<? extends VDC>, Map<String, ? extends VDC>>(){

                @Override
                public Map<String, ? extends VDC> apply(Iterable<? extends VDC> from) {
                    return Maps.uniqueIndex(from, name);
                }
            });
        }
    }

    @Singleton
    private static class OrgNameToOrgSupplier
    implements Supplier<Map<String, ReferenceType>> {
        private final Supplier<VCloudSession> sessionSupplier;

        @Inject
        OrgNameToOrgSupplier(Supplier<VCloudSession> sessionSupplier) {
            this.sessionSupplier = sessionSupplier;
        }

        @Override
        public Map<String, ReferenceType> get() {
            return this.sessionSupplier.get().getOrgs();
        }
    }

    @Singleton
    public static class URItoVDC
    implements Supplier<Map<URI, ? extends VDC>> {
        private final Supplier<Map<String, Map<String, ? extends VDC>>> orgVDCMap;

        @Inject
        URItoVDC(Supplier<Map<String, Map<String, ? extends VDC>>> orgVDCMap) {
            this.orgVDCMap = orgVDCMap;
        }

        @Override
        public Map<URI, ? extends VDC> get() {
            return Maps.uniqueIndex(Iterables.concat(Iterables.transform(this.orgVDCMap.get().values(), new Function<Map<String, ? extends VDC>, Iterable<? extends VDC>>(){

                @Override
                public Iterable<? extends VDC> apply(Map<String, ? extends VDC> from) {
                    return from.values();
                }
            })), new Function<VDC, URI>(){

                @Override
                public URI apply(VDC from) {
                    return from.getHref();
                }
            });
        }
    }

    @Singleton
    public static class OrgCatalogSupplier
    implements Supplier<Map<String, Map<String, ? extends Catalog>>> {
        protected final Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> orgSupplier;
        protected final Function<org.jclouds.trmk.vcloud_0_8.domain.Org, Iterable<? extends Catalog>> allCatalogsInOrg;

        @Inject
        protected OrgCatalogSupplier(Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> orgSupplier, Function<org.jclouds.trmk.vcloud_0_8.domain.Org, Iterable<? extends Catalog>> allCatalogsInOrg) {
            this.orgSupplier = orgSupplier;
            this.allCatalogsInOrg = allCatalogsInOrg;
        }

        @Override
        public Map<String, Map<String, ? extends Catalog>> get() {
            return Maps.transformValues(Maps.transformValues(this.orgSupplier.get(), this.allCatalogsInOrg), new Function<Iterable<? extends Catalog>, Map<String, ? extends Catalog>>(){

                @Override
                public Map<String, ? extends Catalog> apply(Iterable<? extends Catalog> from) {
                    return Maps.uniqueIndex(from, name);
                }
            });
        }
    }

    @Singleton
    public static class OrgMapSupplier
    implements Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> {
        protected final Supplier<VCloudSession> sessionSupplier;
        protected final Function<Iterable<String>, Iterable<? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> organizationsForNames;

        @Inject
        protected OrgMapSupplier(Supplier<VCloudSession> sessionSupplier, Function<Iterable<String>, Iterable<? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> organizationsForNames) {
            this.sessionSupplier = sessionSupplier;
            this.organizationsForNames = organizationsForNames;
        }

        @Override
        public Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org> get() {
            return Maps.uniqueIndex(this.organizationsForNames.apply(this.sessionSupplier.get().getOrgs().keySet()), name);
        }
    }
}

