/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.util.ComputeServiceUtils;

@Singleton
public class ParseOsFromVAppTemplateName
implements Function<String, OperatingSystem> {
    protected static final Pattern OS_PATTERN = Pattern.compile("(([^ ]*) ([0-9.]+) ?.*)");
    protected final Map<OsFamily, Map<String, String>> osVersionMap;

    @Inject
    protected ParseOsFromVAppTemplateName(Map<OsFamily, Map<String, String>> osVersionMap) {
        this.osVersionMap = Preconditions.checkNotNull(osVersionMap, "osVersionMap");
    }

    @Override
    public OperatingSystem apply(String from) {
        OperatingSystem.Builder builder = OperatingSystem.builder();
        OsFamily osFamily = ComputeServiceUtils.parseOsFamilyOrUnrecognized(Preconditions.checkNotNull(from, "vapp template name"));
        builder.family(osFamily);
        builder.description(from);
        builder.is64Bit(from.indexOf("64") != -1);
        Matcher matcher = OS_PATTERN.matcher(from);
        if (matcher.find()) {
            builder.version(ComputeServiceUtils.parseVersionOrReturnEmptyString(osFamily, matcher.group(3), this.osVersionMap));
        }
        return builder.build();
    }
}

