/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudClient;
import org.jclouds.trmk.vcloud_0_8.compute.domain.OrgAndName;
import org.jclouds.trmk.vcloud_0_8.domain.Org;
import org.jclouds.trmk.vcloud_0_8.endpoints.VDC;

@Singleton
public class NodeMetadataToOrgAndName
implements Function<NodeMetadata, OrgAndName> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    final Supplier<Map<String, String>> vdcToOrg;
    private final TerremarkVCloudClient client;

    @Inject
    NodeMetadataToOrgAndName(TerremarkVCloudClient client, @VDC Supplier<Map<String, String>> vdcToOrg) {
        this.vdcToOrg = vdcToOrg;
        this.client = client;
    }

    @Override
    public OrgAndName apply(NodeMetadata from) {
        if (from.getGroup() != null) {
            Org org = this.client.findOrgNamed(this.vdcToOrg.get().get(from.getLocation().getId()));
            if (org == null) {
                this.logger.warn("did not find an association for vdc %s in %s", from.getLocation().getId(), this.vdcToOrg);
            } else {
                return new OrgAndName(org.getHref(), from.getGroup());
            }
        }
        return null;
    }
}

