/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.security.SecureRandom;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.config.BaseComputeServiceContextModule;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.strategy.PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.trmk.vcloud_0_8.compute.TerremarkVCloudComputeService;
import org.jclouds.trmk.vcloud_0_8.compute.config.TerremarkBindComputeStrategiesByClass;
import org.jclouds.trmk.vcloud_0_8.compute.config.TerremarkBindComputeSuppliersByClass;
import org.jclouds.trmk.vcloud_0_8.compute.domain.OrgAndName;
import org.jclouds.trmk.vcloud_0_8.compute.functions.ImageForVCloudExpressVAppTemplate;
import org.jclouds.trmk.vcloud_0_8.compute.functions.ImagesInVCloudExpressOrg;
import org.jclouds.trmk.vcloud_0_8.compute.functions.NodeMetadataToOrgAndName;
import org.jclouds.trmk.vcloud_0_8.compute.functions.ParseOsFromVAppTemplateName;
import org.jclouds.trmk.vcloud_0_8.compute.functions.VAppToNodeMetadata;
import org.jclouds.trmk.vcloud_0_8.compute.options.TerremarkVCloudTemplateOptions;
import org.jclouds.trmk.vcloud_0_8.compute.strategy.ParseVAppTemplateDescriptionToGetDefaultLoginCredentials;
import org.jclouds.trmk.vcloud_0_8.domain.Org;
import org.jclouds.trmk.vcloud_0_8.domain.Status;
import org.jclouds.trmk.vcloud_0_8.domain.VApp;
import org.jclouds.trmk.vcloud_0_8.domain.VAppTemplate;

public class TerremarkVCloudComputeServiceContextModule
extends BaseComputeServiceContextModule {
    @VisibleForTesting
    public static final Map<Status, NodeMetadata.Status> toPortableNodeStatus = ImmutableMap.builder().put(Status.OFF, NodeMetadata.Status.SUSPENDED).put(Status.ON, NodeMetadata.Status.RUNNING).put(Status.RESOLVED, NodeMetadata.Status.PENDING).put(Status.UNRECOGNIZED, NodeMetadata.Status.UNRECOGNIZED).put(Status.DEPLOYED, NodeMetadata.Status.PENDING).put(Status.SUSPENDED, NodeMetadata.Status.SUSPENDED).put(Status.UNRESOLVED, NodeMetadata.Status.PENDING).build();
    @VisibleForTesting
    public static final Map<Status, Image.Status> toPortableImageStatus = ImmutableMap.builder().put(Status.RESOLVED, Image.Status.AVAILABLE).put(Status.OFF, Image.Status.AVAILABLE).put(Status.UNRECOGNIZED, Image.Status.UNRECOGNIZED).put(Status.DEPLOYED, Image.Status.PENDING).put(Status.UNRESOLVED, Image.Status.PENDING).build();

    @Singleton
    @Provides
    protected Map<Status, NodeMetadata.Status> toPortableNodeStatus() {
        return toPortableNodeStatus;
    }

    @Singleton
    @Provides
    protected Map<Status, Image.Status> toPortableImageStatus() {
        return toPortableImageStatus;
    }

    @Override
    protected void configure() {
        super.configure();
        this.bind(new TypeLiteral<Function<NodeMetadata, OrgAndName>>(){}).to((TypeLiteral<Function<NodeMetadata, OrgAndName>>)new TypeLiteral<NodeMetadataToOrgAndName>(){});
        this.bind(TemplateOptions.class).to(TerremarkVCloudTemplateOptions.class);
        this.bind(ComputeService.class).to(TerremarkVCloudComputeService.class);
        this.bind(PopulateDefaultLoginCredentialsForImageStrategy.class).to(ParseVAppTemplateDescriptionToGetDefaultLoginCredentials.class);
        this.bind(SecureRandom.class).toInstance(new SecureRandom());
        this.install(new TerremarkBindComputeStrategiesByClass());
        this.install(new TerremarkBindComputeSuppliersByClass());
        this.bind(new TypeLiteral<Function<VApp, NodeMetadata>>(){}).to(VAppToNodeMetadata.class);
        this.bind(new TypeLiteral<Function<VAppTemplate, Image>>(){}).to(ImageForVCloudExpressVAppTemplate.class);
        this.bind(new TypeLiteral<Function<Org, Iterable<? extends Image>>>(){}).to((TypeLiteral<Function<Org, Iterable<? extends Image>>>)new TypeLiteral<ImagesInVCloudExpressOrg>(){});
        this.bind(new TypeLiteral<Function<String, OperatingSystem>>(){}).to(ParseOsFromVAppTemplateName.class);
    }

    @Provides
    @Singleton
    Supplier<String> provideSuffix(final SecureRandom random) {
        return new Supplier<String>(){

            @Override
            public String get() {
                return random.nextInt(4096) + "";
            }
        };
    }

    @Named(value="PASSWORD")
    @Provides
    String providePassword(SecureRandom random) {
        return random.nextLong() + "";
    }
}

