/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.location.predicates.LocationPredicates;
import org.jclouds.logging.Logger;
import org.jclouds.s3.Bucket;

@Singleton
public class LocationFromBucketName
implements Function<String, Location> {
    private final Supplier<Set<? extends Location>> locations;
    private final Function<String, Optional<String>> bucketToRegion;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    LocationFromBucketName(@Bucket Function<String, Optional<String>> bucketToRegion, @Memoized Supplier<Set<? extends Location>> locations) {
        this.bucketToRegion = bucketToRegion;
        this.locations = locations;
    }

    @Override
    public Location apply(String bucket) {
        Set<? extends Location> locations = this.locations.get();
        if (locations.size() == 1) {
            return Iterables.get(locations, 0);
        }
        Optional<String> region = this.bucketToRegion.apply(bucket);
        if (region.isPresent()) {
            try {
                return Iterables.find(locations, LocationPredicates.idEquals(region.get()));
            }
            catch (NoSuchElementException e) {
                this.logger.debug("could not get location for region %s in %s", region, locations);
            }
        } else {
            this.logger.debug("could not get region for %s", bucket);
        }
        return null;
    }
}

