/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.rackspace.cloudloadbalancers.domain.internal.BaseNode;

public class Node
extends BaseNode<Node> {
    private int id;
    private Status status;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().from(this);
    }

    Node() {
    }

    public Node(int id, String address, int port, BaseNode.Condition condition, Status status, Integer weight) {
        super(address, port, condition, weight);
        Preconditions.checkArgument(id != -1, "id must be specified");
        this.id = id;
        this.status = Preconditions.checkNotNull(status, "status");
    }

    public int getId() {
        return this.id;
    }

    public Status getStatus() {
        return this.status;
    }

    @Override
    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).omitNullValues().add("address", this.address).add("port", this.port).add("condition", (Object)this.condition).add("weight", this.weight).add("status", (Object)this.status);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Node that = (Node)Node.class.cast(obj);
        return Objects.equal(this.id, that.id);
    }

    public static enum Status {
        ONLINE,
        OFFLINE,
        DRAINING,
        UNRECOGNIZED;


        public static Status fromValue(String status) {
            try {
                return Status.valueOf(Preconditions.checkNotNull(status, "status"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static class Builder
    extends BaseNode.Builder<Node> {
        private int id = -1;
        private Status status;

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Node build() {
            return new Node(this.id, this.address, this.port, this.condition, this.status, this.weight);
        }

        public Builder address(String address) {
            return (Builder)Builder.class.cast(super.address(address));
        }

        public Builder condition(BaseNode.Condition condition) {
            return (Builder)Builder.class.cast(super.condition(condition));
        }

        public Builder from(Node in) {
            return ((Builder)Builder.class.cast(super.from(in))).id(in.getId()).status(in.getStatus());
        }

        public Builder port(int port) {
            return (Builder)Builder.class.cast(super.port(port));
        }

        public Builder weight(Integer weight) {
            return (Builder)Builder.class.cast(super.weight(weight));
        }
    }
}

