/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.config;

import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.util.Map;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.json.config.GsonModule;
import org.jclouds.rackspace.cloudloadbalancers.CloudLoadBalancersApi;
import org.jclouds.rackspace.cloudloadbalancers.CloudLoadBalancersAsyncApi;
import org.jclouds.rackspace.cloudloadbalancers.features.LoadBalancerApi;
import org.jclouds.rackspace.cloudloadbalancers.features.LoadBalancerAsyncApi;
import org.jclouds.rackspace.cloudloadbalancers.features.NodeApi;
import org.jclouds.rackspace.cloudloadbalancers.features.NodeAsyncApi;
import org.jclouds.rackspace.cloudloadbalancers.functions.ConvertLB;
import org.jclouds.rackspace.cloudloadbalancers.handlers.ParseCloudLoadBalancersErrorFromHttpResponse;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.config.RestClientModule;

@ConfiguresRestClient
public class CloudLoadBalancersRestClientModule
extends RestClientModule<CloudLoadBalancersApi, CloudLoadBalancersAsyncApi> {
    public static final Map<Class<?>, Class<?>> DELEGATE_MAP = ImmutableMap.builder().put(LoadBalancerApi.class, LoadBalancerAsyncApi.class).put(NodeApi.class, NodeAsyncApi.class).build();

    public CloudLoadBalancersRestClientModule() {
        super(DELEGATE_MAP);
    }

    @Override
    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
        this.install(new FactoryModuleBuilder().build(ConvertLB.Factory.class));
        super.configure();
    }

    @Override
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseCloudLoadBalancersErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseCloudLoadBalancersErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseCloudLoadBalancersErrorFromHttpResponse.class);
    }
}

