/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.domain.internal;

import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.jclouds.openstack.swift.domain.MutableObjectInfoWithMetadata;
import org.jclouds.openstack.swift.domain.ObjectInfo;

public class MutableObjectInfoWithMetadataImpl
implements MutableObjectInfoWithMetadata {
    private String name;
    private String container;
    private URI uri;
    private Long bytes;
    private byte[] hash;
    private String contentType = "application/octet-stream";
    private Date lastModified;
    private final Map<String, String> metadata = Maps.newLinkedHashMap();

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public void setBytes(Long bytes) {
        this.bytes = bytes;
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public void setHash(byte[] hash) {
        this.hash = hash;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Long getBytes() {
        return this.bytes;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public byte[] getHash() {
        return this.hash;
    }

    @Override
    public Date getLastModified() {
        return this.lastModified;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.container == null ? 0 : this.container.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MutableObjectInfoWithMetadataImpl other = (MutableObjectInfoWithMetadataImpl)obj;
        if (this.container == null ? other.container != null : !this.container.equals(other.container)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(ObjectInfo o) {
        return this == o ? 0 : this.getName().compareTo(o.getName());
    }

    @Override
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    @Override
    public String getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(String container) {
        this.container = container;
    }

    @Override
    public void setUri(URI uri) {
        this.uri = uri;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    public String toString() {
        return String.format("[name=%s, container=%s, uri=%s, bytes=%s, contentType=%s, lastModified=%s, hash=%s]", this.name, this.container, this.uri, this.bytes, this.contentType, this.lastModified, Arrays.toString(this.hash));
    }
}

