/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.config;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jclouds.blobstore.config.BlobStoreObjectModule;
import org.jclouds.openstack.swift.domain.MutableObjectInfoWithMetadata;
import org.jclouds.openstack.swift.domain.SwiftObject;
import org.jclouds.openstack.swift.domain.internal.SwiftObjectImpl;

public class SwiftObjectModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.install(new BlobStoreObjectModule());
        this.bind(SwiftObject.Factory.class).to(SwiftObjectFactory.class).in(Scopes.SINGLETON);
    }

    @Provides
    SwiftObject provideSwiftObject(SwiftObject.Factory factory) {
        return factory.create(null);
    }

    private static class SwiftObjectFactory
    implements SwiftObject.Factory {
        @Inject
        Provider<MutableObjectInfoWithMetadata> metadataProvider;

        private SwiftObjectFactory() {
        }

        @Override
        public SwiftObject create(MutableObjectInfoWithMetadata metadata) {
            return new SwiftObjectImpl(metadata != null ? metadata : this.metadataProvider.get());
        }
    }
}

