/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class ServerExtendedAttributes {
    public static String PREFIX;
    @Named(value="OS-EXT-SRV-ATTR:instance_name")
    private final String instanceName;
    @Named(value="OS-EXT-SRV-ATTR:host")
    private final String hostName;
    @Named(value="OS-EXT-SRV-ATTR:hypervisor_hostname")
    private final String hypervisorHostName;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromServerExtendedAttributes(this);
    }

    @ConstructorProperties(value={"OS-EXT-SRV-ATTR:instance_name", "OS-EXT-SRV-ATTR:host", "OS-EXT-SRV-ATTR:hypervisor_hostname"})
    protected ServerExtendedAttributes(@Nullable String instanceName, @Nullable String hostName, @Nullable String hypervisorHostName) {
        this.instanceName = instanceName;
        this.hostName = hostName;
        this.hypervisorHostName = hypervisorHostName;
    }

    @Nullable
    public String getInstanceName() {
        return this.instanceName;
    }

    @Nullable
    public String getHostName() {
        return this.hostName;
    }

    @Nullable
    public String getHypervisorHostName() {
        return this.hypervisorHostName;
    }

    public int hashCode() {
        return Objects.hashCode(this.instanceName, this.hostName, this.hypervisorHostName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ServerExtendedAttributes that = (ServerExtendedAttributes)ServerExtendedAttributes.class.cast(obj);
        return Objects.equal(this.instanceName, that.instanceName) && Objects.equal(this.hostName, that.hostName) && Objects.equal(this.hypervisorHostName, that.hypervisorHostName);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("instanceName", this.instanceName).add("hostName", this.hostName).add("hypervisorHostName", this.hypervisorHostName);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String instanceName;
        protected String hostName;
        protected String hypervisorHostName;

        protected abstract T self();

        public T instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this.self();
        }

        public T hostName(String hostName) {
            this.hostName = hostName;
            return this.self();
        }

        public T hypervisorHostName(String hypervisorHostName) {
            this.hypervisorHostName = hypervisorHostName;
            return this.self();
        }

        public ServerExtendedAttributes build() {
            return new ServerExtendedAttributes(this.instanceName, this.hostName, this.hypervisorHostName);
        }

        public T fromServerExtendedAttributes(ServerExtendedAttributes in) {
            return ((Builder)((Builder)this.instanceName(in.getInstanceName())).hostName(in.getHostName())).hypervisorHostName(in.getHypervisorHostName());
        }
    }
}

