/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.cinder.v1.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.concurrent.TimeUnit;
import org.jclouds.openstack.cinder.v1.domain.Snapshot;
import org.jclouds.openstack.cinder.v1.domain.Volume;
import org.jclouds.openstack.cinder.v1.features.SnapshotApi;
import org.jclouds.predicates.RetryablePredicate;

public class SnapshotPredicates {
    public static RetryablePredicate<Snapshot> awaitAvailable(SnapshotApi snapshotApi) {
        StatusUpdatedPredicate statusPredicate = new StatusUpdatedPredicate(snapshotApi, Volume.Status.AVAILABLE);
        return new RetryablePredicate<Snapshot>(statusPredicate, 1200L, 5L, 5L, TimeUnit.SECONDS);
    }

    public static RetryablePredicate<Snapshot> awaitDeleted(SnapshotApi snapshotApi) {
        DeletedPredicate deletedPredicate = new DeletedPredicate(snapshotApi);
        return new RetryablePredicate<Snapshot>(deletedPredicate, 1200L, 5L, 5L, TimeUnit.SECONDS);
    }

    public static RetryablePredicate<Snapshot> awaitStatus(SnapshotApi snapshotApi, Volume.Status status, long maxWaitInSec, long periodInSec) {
        StatusUpdatedPredicate statusPredicate = new StatusUpdatedPredicate(snapshotApi, status);
        return new RetryablePredicate<Snapshot>(statusPredicate, maxWaitInSec, periodInSec, periodInSec, TimeUnit.SECONDS);
    }

    private static class DeletedPredicate
    implements Predicate<Snapshot> {
        private SnapshotApi snapshotApi;

        public DeletedPredicate(SnapshotApi snapshotApi) {
            this.snapshotApi = Preconditions.checkNotNull(snapshotApi, "snapshotApi must be defined");
        }

        @Override
        public boolean apply(Snapshot snapshot) {
            Preconditions.checkNotNull(snapshot, "snapshot must be defined");
            return this.snapshotApi.get(snapshot.getId()) == null;
        }
    }

    private static class StatusUpdatedPredicate
    implements Predicate<Snapshot> {
        private SnapshotApi snapshotApi;
        private Volume.Status status;

        public StatusUpdatedPredicate(SnapshotApi snapshotApi, Volume.Status status) {
            this.snapshotApi = Preconditions.checkNotNull(snapshotApi, "snapshotApi must be defined");
            this.status = Preconditions.checkNotNull(status, "status must be defined");
        }

        @Override
        public boolean apply(Snapshot snapshot) {
            Preconditions.checkNotNull(snapshot, "snapshot must be defined");
            if (this.status.equals((Object)snapshot.getStatus())) {
                return true;
            }
            Snapshot snapshotUpdated = this.snapshotApi.get(snapshot.getId());
            Preconditions.checkNotNull(snapshotUpdated, "Snapshot %s not found.", snapshot.getId());
            return this.status.equals((Object)snapshotUpdated.getStatus());
        }
    }
}

