/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.logging.log4j;

import org.apache.log4j.Level;
import org.jclouds.logging.BaseLogger;
import org.jclouds.logging.Logger;

public class Log4JLogger
extends BaseLogger {
    private final org.apache.log4j.Logger logger;
    private final String category;

    public Log4JLogger(String category, org.apache.log4j.Logger logger) {
        this.category = category;
        this.logger = logger;
    }

    @Override
    protected void logTrace(String message) {
        this.logger.trace(message);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    protected void logDebug(String message) {
        this.logger.debug(message);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    protected void logInfo(String message) {
        this.logger.info(message);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    protected void logWarn(String message) {
        this.logger.warn(message);
    }

    @Override
    protected void logWarn(String message, Throwable e) {
        this.logger.warn(message, e);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor(Level.WARN);
    }

    @Override
    protected void logError(String message) {
        this.logger.error(message);
    }

    @Override
    protected void logError(String message, Throwable e) {
        this.logger.error(message, e);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor(Level.ERROR);
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    public static class Log4JLoggerFactory
    implements Logger.LoggerFactory {
        @Override
        public Logger getLogger(String category) {
            return new Log4JLogger(category, org.apache.log4j.Logger.getLogger(category));
        }
    }
}

