/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.predicates.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import org.jclouds.compute.domain.ComputeMetadataIncludingStatus;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.logging.Logger;

public abstract class TrueIfNullOrDeletedRefreshAndDoubleCheckOnFalse<S extends Enum<S>, C extends ComputeMetadataIncludingStatus<S>>
implements Predicate<AtomicReference<C>> {
    protected final S deletedStatus;
    @Resource
    protected Logger logger = Logger.NULL;

    protected TrueIfNullOrDeletedRefreshAndDoubleCheckOnFalse(S deletedStatus) {
        this.deletedStatus = (Enum)Preconditions.checkNotNull(deletedStatus, "deletedStatus");
    }

    @Override
    public boolean apply(AtomicReference<C> atomicResource) {
        ComputeMetadataIncludingStatus resource = (ComputeMetadataIncludingStatus)atomicResource.get();
        if (this.checkStatus(resource)) {
            return true;
        }
        resource = this.refreshOrNull(resource);
        atomicResource.set(resource);
        return this.checkStatus(resource);
    }

    public boolean checkStatus(C resource) {
        if (resource == null) {
            return true;
        }
        this.logger.trace("%s: looking for resource status %s: currently: %s", resource.getId(), this.deletedStatus, ComputeServiceUtils.formatStatus(resource));
        return resource.getStatus() == this.deletedStatus;
    }

    protected abstract C refreshOrNull(C var1);
}

