/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.domain;

import com.google.common.base.Objects;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.cloudwatch.domain.Metric;
import org.jclouds.javax.annotation.Nullable;

public class ListMetricsResponse
extends ForwardingSet<Metric> {
    private final Set<Metric> metrics;
    private final String nextToken;

    public ListMetricsResponse(@Nullable Set<Metric> metrics, @Nullable String nextToken) {
        this.metrics = metrics == null ? ImmutableSet.of() : ImmutableSet.copyOf(metrics);
        this.nextToken = nextToken;
    }

    @Nullable
    public String getNextToken() {
        return this.nextToken;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.metrics, this.nextToken);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListMetricsResponse other = (ListMetricsResponse)obj;
        return Objects.equal(this.metrics, other.metrics) && Objects.equal(this.nextToken, other.nextToken);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper(this).add("metrics", this.metrics).add("nextToken", this.nextToken).toString();
    }

    @Override
    protected Set<Metric> delegate() {
        return this.metrics;
    }
}

