/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import org.jclouds.cloudstack.options.AccountInDomainOptions;

public class AssignVirtualMachineOptions
extends AccountInDomainOptions {
    public static final AssignVirtualMachineOptions NONE = new AssignVirtualMachineOptions();

    public AssignVirtualMachineOptions networkId(String networkId) {
        this.queryParameters.replaceValues("networkids", ImmutableSet.of(networkId + ""));
        return this;
    }

    public AssignVirtualMachineOptions networkIds(Iterable<String> networkIds) {
        this.queryParameters.replaceValues("networkids", ImmutableSet.of(Joiner.on(',').join(networkIds)));
        return this;
    }

    public Iterable<String> getNetworkIds() {
        if (this.queryParameters.get("networkids").size() == 1) {
            return Iterables.transform(Splitter.on(",").split((CharSequence)Iterables.getOnlyElement(this.queryParameters.get("networkids"))), new Function<String, String>(){

                @Override
                public String apply(String arg0) {
                    return arg0;
                }
            });
        }
        return ImmutableSet.of();
    }

    public AssignVirtualMachineOptions securityGroupId(String securityGroupId) {
        this.queryParameters.replaceValues("securitygroupids", ImmutableSet.of(securityGroupId + ""));
        return this;
    }

    public AssignVirtualMachineOptions securityGroupIds(Iterable<String> securityGroupIds) {
        this.queryParameters.replaceValues("securitygroupids", ImmutableSet.of(Joiner.on(',').join(securityGroupIds)));
        return this;
    }

    @Override
    public AssignVirtualMachineOptions accountInDomain(String account, String domain) {
        return (AssignVirtualMachineOptions)AssignVirtualMachineOptions.class.cast(super.accountInDomain(account, domain));
    }

    @Override
    public AssignVirtualMachineOptions domainId(String domainId) {
        return (AssignVirtualMachineOptions)AssignVirtualMachineOptions.class.cast(super.domainId(domainId));
    }

    public static class Builder {
        public static AssignVirtualMachineOptions networkId(String id) {
            AssignVirtualMachineOptions options = new AssignVirtualMachineOptions();
            return options.networkId(id);
        }

        public static AssignVirtualMachineOptions networkIds(Iterable<String> networkIds) {
            AssignVirtualMachineOptions options = new AssignVirtualMachineOptions();
            return options.networkIds(networkIds);
        }

        public static AssignVirtualMachineOptions securityGroupId(String id) {
            AssignVirtualMachineOptions options = new AssignVirtualMachineOptions();
            return options.securityGroupId(id);
        }

        public static AssignVirtualMachineOptions securityGroupIds(Iterable<String> securityGroupIds) {
            AssignVirtualMachineOptions options = new AssignVirtualMachineOptions();
            return options.securityGroupIds(securityGroupIds);
        }

        public static AssignVirtualMachineOptions accountInDomain(String account, String domain) {
            AssignVirtualMachineOptions options = new AssignVirtualMachineOptions();
            return options.accountInDomain(account, domain);
        }

        public static AssignVirtualMachineOptions domainId(String domainId) {
            AssignVirtualMachineOptions options = new AssignVirtualMachineOptions();
            return options.domainId(domainId);
        }
    }
}

