/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.cloudservers.CloudServersClient;
import org.jclouds.cloudservers.domain.Server;
import org.jclouds.cloudservers.domain.ServerStatus;
import org.jclouds.logging.Logger;

@Singleton
public class ServerDeleted
implements Predicate<Server> {
    private final CloudServersClient client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public ServerDeleted(CloudServersClient client) {
        this.client = client;
    }

    @Override
    public boolean apply(Server server) {
        this.logger.trace("looking for state on server %s", Preconditions.checkNotNull(server, "server"));
        server = this.refresh(server);
        if (server == null) {
            return true;
        }
        this.logger.trace("%s: looking for server state %s: currently: %s", new Object[]{server.getId(), ServerStatus.DELETED, server.getStatus()});
        return server.getStatus() == ServerStatus.DELETED;
    }

    private Server refresh(Server server) {
        return this.client.getServer(server.getId());
    }
}

