/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore.config;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.jclouds.azureblob.AzureBlobClient;
import org.jclouds.azureblob.blobstore.AzureAsyncBlobStore;
import org.jclouds.azureblob.blobstore.AzureBlobRequestSigner;
import org.jclouds.azureblob.blobstore.AzureBlobStore;
import org.jclouds.azureblob.blobstore.strategy.FindMD5InBlobProperties;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.attr.ConsistencyModel;
import org.jclouds.blobstore.config.BlobStoreMapModule;
import org.jclouds.blobstore.strategy.ContainsValueInListStrategy;

public class AzureBlobStoreContextModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.install(new BlobStoreMapModule());
        this.bind(ConsistencyModel.class).toInstance(ConsistencyModel.STRICT);
        this.bind(AsyncBlobStore.class).to(AzureAsyncBlobStore.class).in(Scopes.SINGLETON);
        this.bind(BlobStore.class).to(AzureBlobStore.class).in(Scopes.SINGLETON);
        this.bind(ContainsValueInListStrategy.class).to(FindMD5InBlobProperties.class);
        this.bind(BlobRequestSigner.class).to(AzureBlobRequestSigner.class);
    }

    @Provides
    @Singleton
    protected LoadingCache<String, PublicAccess> containerAcls(final AzureBlobClient client) {
        return CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build(new CacheLoader<String, PublicAccess>(){

            @Override
            public PublicAccess load(String container) {
                return client.getPublicAccessForContainer(container);
            }

            public String toString() {
                return "getPublicAccessForContainer()";
            }
        });
    }
}

