/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azure.storage.handlers;

import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.azure.storage.domain.AzureStorageError;
import org.jclouds.azure.storage.util.AzureStorageUtils;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.logging.Logger;

public class AzureStorageClientErrorRetryHandler
implements HttpRetryHandler {
    @Inject(optional=true)
    @Named(value="jclouds.max-retries")
    private int retryCountLimit = 5;
    private final AzureStorageUtils utils;
    private final BackoffLimitedRetryHandler backoffHandler;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public AzureStorageClientErrorRetryHandler(BackoffLimitedRetryHandler backoffHandler, AzureStorageUtils utils) {
        this.backoffHandler = backoffHandler;
        this.utils = utils;
    }

    @Override
    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        byte[] content = HttpUtils.closeClientButKeepContentStream(response);
        command.incrementFailureCount();
        if (!command.isReplayable()) {
            this.logger.warn("Cannot retry after server error, command is not replayable: %1$s", command);
            return false;
        }
        if (command.getFailureCount() > this.retryCountLimit) {
            this.logger.warn("Cannot retry after server error, command has exceeded retry limit %1$d: %2$s", this.retryCountLimit, command);
            return false;
        }
        if (response.getStatusCode() == 409 && content != null) {
            try {
                AzureStorageError error = this.utils.parseAzureStorageErrorFromContent(command, response, new ByteArrayInputStream(content));
                if ("ContainerBeingDeleted".equals(error.getCode())) {
                    this.backoffHandler.imposeBackoffExponentialDelay(100L, 3, this.retryCountLimit, command.getFailureCount(), command.toString());
                    return true;
                }
            }
            catch (HttpException e) {
                this.logger.warn(e, "error parsing response: %s", new String(content));
            }
        }
        return false;
    }
}

