/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service.jclouds.commands;

import java.util.Dictionary;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.boot.commands.support.FabricCommand;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.osgi.service.cm.Configuration;

@Command(name="cloud-service-remove", scope="fabric", description="Removes a cloud provider from the fabric's registry.")
public class CloudServiceRemove
extends FabricCommand {
    private static final String PID_FILTER = "(service.pid=%s*)";
    @Argument(index=0, name="name", required=true, description="JClouds context name.")
    private String name;

    protected Object doExecute() throws Exception {
        Configuration[] computeConfigs;
        boolean connected = this.getZooKeeper().isConnected();
        Container current = null;
        if (connected) {
            if (this.getZooKeeper().exists(ZkPath.CLOUD_SERVICE.getPath(new String[]{this.name})) != null) {
                this.getZooKeeper().deleteWithChildren(ZkPath.CLOUD_SERVICE.getPath(new String[]{this.name}));
            }
            current = this.fabricService.getCurrentContainer();
        }
        if ((computeConfigs = this.findConfigurationByFactoryPid("org.jclouds.compute")) != null) {
            for (Configuration configuration : computeConfigs) {
                String contextName;
                Dictionary props = configuration.getProperties();
                if (props == null || !this.name.equals(contextName = (String)props.get("name"))) continue;
                configuration.delete();
            }
        }
        return null;
    }

    private Configuration[] findConfigurationByFactoryPid(String factoryPid) {
        Configuration[] configurations = new Configuration[]{};
        try {
            configurations = this.configurationAdmin.listConfigurations(String.format(PID_FILTER, factoryPid));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return configurations;
    }
}

