/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import com.google.common.collect.Maps;
import java.util.Map;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.util.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class OrgListHandler
extends ParseSax.HandlerWithResult<Map<String, ReferenceType>> {
    private Map<String, ReferenceType> org = Maps.newHashMap();

    @Override
    public Map<String, ReferenceType> getResult() {
        return this.org;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        String type;
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (qName.endsWith("Org") && (type = attributes.get("type")) != null && type.indexOf("org+xml") != -1) {
            Utils.putReferenceType(this.org, attributes);
        }
    }
}

