/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.strategy;

import com.google.common.annotations.Beta;
import com.google.common.base.Supplier;
import java.net.URI;
import javax.inject.Inject;
import org.jclouds.ovf.Network;
import org.jclouds.vcloud.compute.options.VCloudTemplateOptions;
import org.jclouds.vcloud.compute.strategy.InstantiateVAppTemplateWithGroupEncodedIntoNameThenCustomizeDeployAndPowerOn;
import org.jclouds.vcloud.domain.network.FenceMode;
import org.jclouds.vcloud.domain.network.NetworkConfig;

@Beta
public class NetworkConfigurationForNetworkAndOptions {
    protected final Supplier<NetworkConfig> defaultNetworkConfig;
    protected final FenceMode defaultFenceMode;

    @Inject
    protected NetworkConfigurationForNetworkAndOptions(Supplier<NetworkConfig> defaultNetworkConfig, FenceMode defaultFenceMode) {
        this.defaultNetworkConfig = defaultNetworkConfig;
        this.defaultFenceMode = defaultFenceMode;
    }

    public NetworkConfig apply(Network networkToConnect, VCloudTemplateOptions vOptions) {
        URI userDefinedParentNetwork = vOptions.getParentNetwork();
        FenceMode fenceMode = vOptions.getFenceMode() != null ? vOptions.getFenceMode() : this.defaultFenceMode;
        NetworkConfig config = userDefinedParentNetwork != null ? NetworkConfig.builder().networkName("jclouds").fenceMode(fenceMode).parentNetwork(userDefinedParentNetwork).build() : this.defaultNetworkConfig.get().toBuilder().fenceMode(fenceMode).build();
        if (!InstantiateVAppTemplateWithGroupEncodedIntoNameThenCustomizeDeployAndPowerOn.networkWithNoIpAllocation.apply(networkToConnect)) {
            config = config.toBuilder().networkName(networkToConnect.getName()).build();
        }
        return config;
    }
}

