/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.xml;

import java.net.URI;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.trmk.vcloud_0_8.domain.InternetService;
import org.jclouds.trmk.vcloud_0_8.domain.Protocol;
import org.jclouds.trmk.vcloud_0_8.domain.PublicIpAddress;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class InternetServiceHandler
extends ParseSax.HandlerWithResult<InternetService> {
    private StringBuilder currentText = new StringBuilder();
    private boolean inPublicIpAddress;
    private URI location;
    private URI addressLocation;
    private String serviceName;
    private String address;
    private PublicIpAddress publicIpAddress;
    private int port;
    private String description;
    private int timeout;
    private boolean enabled;
    private Protocol protocol;
    protected int depth = 0;
    private int thisDepth;

    @Override
    public InternetService getResult() {
        return new InternetService(this.serviceName, this.location, this.publicIpAddress, this.port, this.protocol, this.enabled, this.timeout, this.description);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        ++this.depth;
        if (SaxUtils.equalsOrSuffix(qName, "InternetService")) {
            this.thisDepth = this.depth;
        } else if (SaxUtils.equalsOrSuffix(qName, "PublicIpAddress")) {
            this.inPublicIpAddress = true;
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        --this.depth;
        if (SaxUtils.equalsOrSuffix(qName, "PublicIpAddress")) {
            this.inPublicIpAddress = false;
            this.publicIpAddress = new PublicIpAddress(this.address, this.addressLocation);
            this.address = null;
            this.addressLocation = null;
        } else {
            String value = SaxUtils.currentOrNull(this.currentText);
            if (value != null && !value.equals("")) {
                if (this.depth == this.thisDepth) {
                    if (SaxUtils.equalsOrSuffix(qName, "Href")) {
                        this.location = URI.create(value);
                    } else if (SaxUtils.equalsOrSuffix(qName, "Name")) {
                        this.serviceName = value;
                    } else if (SaxUtils.equalsOrSuffix(qName, "Port")) {
                        this.port = Integer.parseInt(value);
                    } else if (SaxUtils.equalsOrSuffix(qName, "Protocol")) {
                        this.protocol = Protocol.valueOf(value);
                    } else if (SaxUtils.equalsOrSuffix(qName, "Enabled")) {
                        this.enabled = Boolean.parseBoolean(value);
                    } else if (SaxUtils.equalsOrSuffix(qName, "Timeout")) {
                        this.timeout = Integer.parseInt(value);
                    } else if (SaxUtils.equalsOrSuffix(qName, "Description")) {
                        this.description = SaxUtils.currentOrNull(this.currentText);
                    }
                } else if (this.inPublicIpAddress) {
                    if (SaxUtils.equalsOrSuffix(qName, "Href")) {
                        this.addressLocation = URI.create(value);
                    } else if (SaxUtils.equalsOrSuffix(qName, "Name")) {
                        this.address = value;
                    }
                }
            }
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

