/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.domain;

import com.google.common.base.Preconditions;
import com.google.inject.ImplementedBy;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.trmk.vcloud_0_8.domain.internal.ErrorImpl;

@ImplementedBy(value=ErrorImpl.class)
public interface VCloudError {
    public String getMessage();

    public int getMajorErrorCode();

    @Nullable
    public MinorCode getMinorErrorCode();

    @Nullable
    public String getVendorSpecificErrorCode();

    public String getStackTrace();

    public static enum MinorCode {
        ACCESS_TO_RESOURCE_IS_FORBIDDEN,
        BAD_REQUEST,
        CONFLICT,
        BUSY_ENTITY,
        EULA_NOT_ACCEPTED,
        INTERNAL_SERVER_ERROR,
        INVALID_REFERENCE,
        METHOD_NOT_ALLOWED,
        RESOURCE_NOT_FOUND,
        UNKNOWN,
        UNSUPPORTED_MEDIA_TYPE,
        UNRECOGNIZED;


        public static MinorCode fromValue(String minorCode) {
            try {
                return MinorCode.valueOf(Preconditions.checkNotNull(minorCode, "minorCode"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

