/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.domain.Org;

@Singleton
public class VCloudHardwareSupplier
implements Supplier<Set<? extends Hardware>> {
    @Resource
    @Named(value="jclouds.compute")
    public Logger logger = Logger.NULL;
    private final Supplier<Map<String, ? extends Org>> orgMap;
    private final Function<Org, Iterable<? extends Hardware>> sizesInOrg;
    private final ExecutorService executor;

    @Inject
    VCloudHardwareSupplier(Supplier<Map<String, ? extends Org>> orgMap, Function<Org, Iterable<? extends Hardware>> sizesInOrg, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.orgMap = Preconditions.checkNotNull(orgMap, "orgMap");
        this.sizesInOrg = Preconditions.checkNotNull(sizesInOrg, "sizesInOrg");
        this.executor = Preconditions.checkNotNull(executor, "executor");
    }

    @Override
    public Set<? extends Hardware> get() {
        Iterable orgs = Preconditions.checkNotNull(this.orgMap.get().values(), "orgs");
        Iterable<? extends Iterable<? extends Hardware>> sizes = FutureIterables.transformParallel(orgs, new Function<Org, Future<? extends Iterable<? extends Hardware>>>(){

            @Override
            public Future<Iterable<? extends Hardware>> apply(final Org from) {
                Preconditions.checkNotNull(from, "org");
                return VCloudHardwareSupplier.this.executor.submit(new Callable<Iterable<? extends Hardware>>(){

                    @Override
                    public Iterable<? extends Hardware> call() throws Exception {
                        return (Iterable)VCloudHardwareSupplier.this.sizesInOrg.apply(from);
                    }

                    public String toString() {
                        return "sizesInOrg(" + from.getHref() + ")";
                    }
                });
            }
        }, this.executor, null, this.logger, "sizes in " + orgs);
        return Sets.newLinkedHashSet(Iterables.concat(sizes));
    }
}

