/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sts.options;

import com.google.common.base.Objects;
import com.google.common.collect.Multimap;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class FederatedUserOptions
extends BaseHttpRequestOptions
implements Cloneable {
    private Long durationSeconds;
    private String policy;

    public FederatedUserOptions durationSeconds(long durationSeconds) {
        this.durationSeconds = durationSeconds;
        return this;
    }

    public FederatedUserOptions policy(String policy) {
        this.policy = policy;
        return this;
    }

    @Override
    public Multimap<String, String> buildFormParameters() {
        Multimap<String, String> params = super.buildFormParameters();
        if (this.durationSeconds != null) {
            params.put("DurationSeconds", this.durationSeconds.toString());
        }
        if (this.policy != null) {
            params.put("Policy", this.policy);
        }
        return params;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.durationSeconds, this.policy);
    }

    public FederatedUserOptions clone() {
        return new FederatedUserOptions().durationSeconds(this.durationSeconds).policy(this.policy);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FederatedUserOptions other = (FederatedUserOptions)FederatedUserOptions.class.cast(obj);
        return Objects.equal(this.durationSeconds, other.durationSeconds) && Objects.equal(this.policy, other.policy);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper(this).omitNullValues().add("durationSeconds", this.durationSeconds).add("policy", this.policy).toString();
    }

    public static class Builder {
        public static FederatedUserOptions durationSeconds(long durationSeconds) {
            return new FederatedUserOptions().durationSeconds(durationSeconds);
        }

        public static FederatedUserOptions policy(String policy) {
            return new FederatedUserOptions().policy(policy);
        }
    }
}

