/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.softlayer.domain.Datacenter;

@RequestFilters(value={BasicAuthentication.class})
@Path(value="/v{jclouds.api-version}")
public interface DatacenterAsyncClient {
    @GET
    @Path(value="/SoftLayer_Location_Datacenter/Datacenters.json")
    @QueryParams(keys={"objectMask"}, values={"locationAddress;regions"})
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<Datacenter>> listDatacenters();

    @GET
    @Path(value="/SoftLayer_Location_Datacenter/{id}.json")
    @QueryParams(keys={"objectMask"}, values={"locationAddress;regions"})
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Datacenter> getDatacenter(@PathParam(value="id") long var1);
}

