/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.softlayer.domain.Datacenter;
import org.jclouds.softlayer.domain.ProductItem;

public class ProductPackage {
    private final int id;
    private final String name;
    private final String description;
    private final Set<ProductItem> items;
    private final Set<Datacenter> locations;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromProductPackage(this);
    }

    @ConstructorProperties(value={"id", "name", "description", "items", "locations"})
    protected ProductPackage(int id, @Nullable String name, @Nullable String description, @Nullable Set<ProductItem> items, Set<Datacenter> locations) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.items = items == null ? ImmutableSet.of() : ImmutableSet.copyOf(items);
        this.locations = locations == null ? ImmutableSet.of() : ImmutableSet.copyOf(locations);
    }

    public int getId() {
        return this.id;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public Set<ProductItem> getItems() {
        return this.items;
    }

    public Set<Datacenter> getDatacenters() {
        return this.locations;
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ProductPackage that = (ProductPackage)ProductPackage.class.cast(obj);
        return Objects.equal(this.id, that.id);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("id", this.id).add("name", this.name).add("description", this.description).add("items", this.items).add("locations", this.locations);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected int id;
        protected String name;
        protected String description;
        protected Set<ProductItem> items = ImmutableSet.of();
        protected Set<Datacenter> locations = ImmutableSet.of();

        protected abstract T self();

        public T id(int id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T items(Set<ProductItem> items) {
            this.items = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(items, "items"));
            return this.self();
        }

        public T items(ProductItem ... in) {
            return this.items(ImmutableSet.copyOf(in));
        }

        public T datacenters(Set<Datacenter> locations) {
            this.locations = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(locations, "locations"));
            return this.self();
        }

        public T datacenters(Datacenter ... in) {
            return this.datacenters(ImmutableSet.copyOf(in));
        }

        public ProductPackage build() {
            return new ProductPackage(this.id, this.name, this.description, this.items, this.locations);
        }

        public T fromProductPackage(ProductPackage in) {
            return ((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).name(in.getName())).description(in.getDescription())).items(in.getItems())).datacenters(in.getDatacenters());
        }
    }
}

