/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.slicehost.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.domain.Location;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.slicehost.compute.functions.FlavorToHardware;
import org.jclouds.slicehost.compute.functions.SliceToNodeMetadata;
import org.jclouds.slicehost.compute.functions.SlicehostImageToImage;
import org.jclouds.slicehost.compute.functions.SlicehostImageToOperatingSystem;
import org.jclouds.slicehost.compute.strategy.SlicehostComputeServiceAdapter;
import org.jclouds.slicehost.domain.Flavor;
import org.jclouds.slicehost.domain.Slice;

public class SlicehostComputeServiceContextModule
extends ComputeServiceAdapterContextModule<Slice, Flavor, org.jclouds.slicehost.domain.Image, Location> {
    @VisibleForTesting
    public static final Map<Slice.Status, NodeMetadata.Status> sliceStatusToNodeStatus = ImmutableMap.builder().put(Slice.Status.ACTIVE, NodeMetadata.Status.RUNNING).put(Slice.Status.BUILD, NodeMetadata.Status.PENDING).put(Slice.Status.REBOOT, NodeMetadata.Status.PENDING).put(Slice.Status.HARD_REBOOT, NodeMetadata.Status.PENDING).put(Slice.Status.TERMINATED, NodeMetadata.Status.TERMINATED).put(Slice.Status.UNRECOGNIZED, NodeMetadata.Status.UNRECOGNIZED).build();

    @Override
    protected void configure() {
        super.configure();
        this.bind(new TypeLiteral<ComputeServiceAdapter<Slice, Flavor, org.jclouds.slicehost.domain.Image, Location>>(){}).to(SlicehostComputeServiceAdapter.class);
        this.bind(new TypeLiteral<Function<Slice, NodeMetadata>>(){}).to(SliceToNodeMetadata.class);
        this.bind(new TypeLiteral<Function<org.jclouds.slicehost.domain.Image, Image>>(){}).to(SlicehostImageToImage.class);
        this.bind(new TypeLiteral<Function<org.jclouds.slicehost.domain.Image, OperatingSystem>>(){}).to(SlicehostImageToOperatingSystem.class);
        this.bind(new TypeLiteral<Function<Flavor, Hardware>>(){}).to(FlavorToHardware.class);
        this.bind(new TypeLiteral<Function<Location, Location>>(){}).to((Class)Class.class.cast(IdentityFunction.class));
    }

    @Singleton
    @Provides
    Map<Slice.Status, NodeMetadata.Status> provideSliceToNodeStatus() {
        return sliceStatusToNodeStatus;
    }
}

