/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.xml;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.IterableWithMarkers;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.route53.domain.Zone;
import org.jclouds.route53.xml.ZoneHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class ListHostedZonesResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<IterableWithMarker<Zone>> {
    private final ZoneHandler zoneHandler;
    private StringBuilder currentText = new StringBuilder();
    private ImmutableList.Builder<Zone> zones = ImmutableList.builder();
    private boolean inZones;
    private String afterMarker;

    @Inject
    public ListHostedZonesResponseHandler(ZoneHandler zoneHandler) {
        this.zoneHandler = zoneHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IterableWithMarker<Zone> getResult() {
        try {
            IterableWithMarker<Zone> iterableWithMarker = IterableWithMarkers.from(this.zones.build(), this.afterMarker);
            return iterableWithMarker;
        }
        finally {
            this.zones = ImmutableList.builder();
        }
    }

    @Override
    public void startElement(String url, String name, String qName, Attributes attributes) {
        if (SaxUtils.equalsOrSuffix(qName, "HostedZones")) {
            this.inZones = true;
        }
        if (this.inZones) {
            this.zoneHandler.startElement(url, name, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (this.inZones) {
            if (qName.equals("HostedZones")) {
                this.inZones = false;
            } else if (qName.equals("HostedZone")) {
                this.zones.add((Object)this.zoneHandler.getResult());
            } else {
                this.zoneHandler.endElement(uri, name, qName);
            }
        } else if (qName.equals("NextMarker")) {
            this.afterMarker = SaxUtils.currentOrNull(this.currentText);
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.inZones) {
            this.zoneHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

