/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.annotations.Beta;
import com.google.common.collect.FluentIterable;
import com.google.common.util.concurrent.ListenableFuture;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.binders.BindKeyPairToJsonPayload;
import org.jclouds.openstack.nova.v2_0.domain.KeyPair;
import org.jclouds.openstack.nova.v2_0.functions.internal.ParseKeyPairs;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.functions.ReturnEmptyFluentIterableOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnFalseOnNotFoundOr404;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/keypairs/api/v1.1")
@RequestFilters(value={AuthenticateRequest.class})
@Beta
public interface KeyPairAsyncApi {
    @GET
    @Path(value="/os-keypairs")
    @ResponseParser(value=ParseKeyPairs.class)
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptyFluentIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends FluentIterable<? extends KeyPair>> list();

    @POST
    @Path(value="/os-keypairs")
    @SelectJson(value={"keypair"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Payload(value="%7B\"keypair\":%7B\"name\":\"{name}\"%7D%7D")
    public ListenableFuture<? extends KeyPair> create(@PayloadParam(value="name") String var1);

    @POST
    @Path(value="/os-keypairs")
    @SelectJson(value={"keypair"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @MapBinder(value=BindKeyPairToJsonPayload.class)
    public ListenableFuture<? extends KeyPair> createWithPublicKey(@PayloadParam(value="name") String var1, @PayloadParam(value="public_key") String var2);

    @DELETE
    @Path(value="/os-keypairs/{name}")
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    @Consumes
    public ListenableFuture<Boolean> delete(@PathParam(value="name") String var1);
}

