/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.annotations.Beta;
import com.google.common.collect.FluentIterable;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.domain.HostAggregate;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.WrapWith;
import org.jclouds.rest.functions.ReturnEmptyFluentIterableOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnFalseOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/aggregates/api/v1.1")
@RequestFilters(value={AuthenticateRequest.class})
@Path(value="/os-aggregates")
@Beta
public interface HostAggregateAsyncApi {
    @GET
    @SelectJson(value={"aggregates"})
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptyFluentIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends FluentIterable<? extends HostAggregate>> list();

    @GET
    @Path(value="/{id}")
    @SelectJson(value={"aggregate"})
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends HostAggregate> get(@PathParam(value="id") String var1);

    @POST
    @SelectJson(value={"aggregate"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @WrapWith(value="aggregate")
    public ListenableFuture<? extends HostAggregate> createInAvailabilityZone(@PayloadParam(value="name") String var1, @PayloadParam(value="availability_zone") String var2);

    @POST
    @Path(value="/{id}")
    @SelectJson(value={"aggregate"})
    @Consumes(value={"application/json"})
    @WrapWith(value="aggregate")
    public ListenableFuture<? extends HostAggregate> updateName(@PathParam(value="id") String var1, @PayloadParam(value="name") String var2);

    @POST
    @Path(value="/{id}")
    @SelectJson(value={"aggregate"})
    @Consumes(value={"application/json"})
    @WrapWith(value="aggregate")
    public ListenableFuture<? extends HostAggregate> updateAvailabilityZone(@PathParam(value="id") String var1, @PayloadParam(value="availability_zone") String var2);

    @DELETE
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> delete(@PathParam(value="id") String var1);

    @POST
    @Path(value="/{id}/action")
    @SelectJson(value={"aggregate"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @WrapWith(value="add_host")
    public ListenableFuture<? extends HostAggregate> addHost(@PathParam(value="id") String var1, @PayloadParam(value="host") String var2);

    @POST
    @Path(value="/{id}/action")
    @SelectJson(value={"aggregate"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @WrapWith(value="remove_host")
    public ListenableFuture<? extends HostAggregate> removeHost(@PathParam(value="id") String var1, @PayloadParam(value="host") String var2);

    @POST
    @Path(value="/{id}/action")
    @SelectJson(value={"aggregate"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @WrapWith(value="set_metadata")
    public ListenableFuture<? extends HostAggregate> setMetadata(@PathParam(value="id") String var1, @PayloadParam(value="metadata") Map<String, String> var2);
}

