/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class SecurityGroup {
    private final int id;
    private final String name;
    private final String description;
    private final String tenantId;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromSecurityGroup(this);
    }

    @ConstructorProperties(value={"id", "name", "description", "tenant_id"})
    protected SecurityGroup(int id, String name, @Nullable String description, @Nullable String tenantId) {
        this.id = id;
        this.name = Preconditions.checkNotNull(name, "name");
        this.description = description;
        this.tenantId = tenantId;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getTenantId() {
        return this.tenantId;
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.name, this.description, this.tenantId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SecurityGroup that = (SecurityGroup)SecurityGroup.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.name, that.name) && Objects.equal(this.description, that.description) && Objects.equal(this.tenantId, that.tenantId);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("id", this.id).add("name", this.name).add("description", this.description).add("tenantId", this.tenantId);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected int id;
        protected String name;
        protected String description;
        protected String tenantId;

        protected abstract T self();

        public T id(int id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this.self();
        }

        public SecurityGroup build() {
            return new SecurityGroup(this.id, this.name, this.description, this.tenantId);
        }

        public T fromSecurityGroup(SecurityGroup in) {
            return ((Builder)((Builder)((Builder)this.id(in.getId())).name(in.getName())).description(in.getDescription())).tenantId(in.getTenantId());
        }
    }
}

