/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FilterStringsBoundToInjectorByName
implements Function<Predicate<String>, Map<String, String>> {
    private final Injector injector;

    @Inject
    public FilterStringsBoundToInjectorByName(Injector injector) {
        this.injector = Preconditions.checkNotNull(injector, "injector");
    }

    @Override
    public Map<String, String> apply(Predicate<String> filter) {
        List<Binding<String>> stringBindings = this.injector.findBindingsByType(new TypeLiteral<String>(){});
        Iterable<Binding<String>> annotatedWithName = Iterables.filter(stringBindings, new Predicate<Binding<String>>(){

            @Override
            public boolean apply(Binding<String> input) {
                Annotation annotation = input.getKey().getAnnotation();
                if (annotation == null) {
                    return false;
                }
                return annotation instanceof javax.inject.Named || annotation instanceof Named;
            }
        });
        ImmutableMap<String, Binding<String>> bindingsByName = Maps.uniqueIndex(annotatedWithName, new Function<Binding<String>, String>(){

            @Override
            public String apply(Binding<String> input) {
                Annotation annotation = input.getKey().getAnnotation();
                return annotation instanceof javax.inject.Named ? ((javax.inject.Named)javax.inject.Named.class.cast(annotation)).value() : ((Named)Named.class.cast(annotation)).value();
            }
        });
        Map<String, Binding<String>> filteredBindingsByName = Maps.filterKeys(bindingsByName, filter);
        Map<String, String> stringBoundByName = Maps.transformValues(filteredBindingsByName, new Function<Binding<String>, String>(){

            @Override
            public String apply(Binding<String> input) {
                return input.getProvider().get();
            }
        });
        return stringBoundByName;
    }
}

