/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.jclouds.elasticstack.domain.ClaimType;
import org.jclouds.elasticstack.domain.Item;
import org.jclouds.javax.annotation.Nullable;

public class Drive
extends Item {
    protected final long size;
    protected final ClaimType claimType;
    protected final Set<String> readers;

    public Drive(@Nullable String uuid, String name, long size, @Nullable ClaimType claimType, Iterable<String> readers, Iterable<String> tags, Map<String, String> userMetadata) {
        super(uuid, name, tags, userMetadata);
        this.size = size;
        this.claimType = Preconditions.checkNotNull(claimType, "set claimType to exclusive, not null");
        this.readers = ImmutableSet.copyOf(Preconditions.checkNotNull(readers, "readers"));
    }

    @Nullable
    public ClaimType getClaimType() {
        return this.claimType;
    }

    public Set<String> getReaders() {
        return this.readers;
    }

    public long getSize() {
        return this.size;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.claimType == null ? 0 : this.claimType.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.readers == null ? 0 : ((Object)this.readers).hashCode());
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (this.tags == null ? 0 : ((Object)this.tags).hashCode());
        result = 31 * result + (this.userMetadata == null ? 0 : ((Object)this.userMetadata).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Drive other = (Drive)obj;
        if (this.claimType != other.claimType) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.readers == null ? other.readers != null : !((Object)this.readers).equals(other.readers)) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (this.tags == null ? other.tags != null : !((Object)this.tags).equals(other.tags)) {
            return false;
        }
        return !(this.userMetadata == null ? other.userMetadata != null : !((Object)this.userMetadata).equals(other.userMetadata));
    }

    @Override
    public String toString() {
        return "[uuid=" + this.uuid + ", name=" + this.name + ", tags=" + this.tags + ", userMetadata=" + this.userMetadata + ", size=" + this.size + ", claimType=" + (Object)((Object)this.claimType) + ", readers=" + this.readers + "]";
    }

    public static class Builder
    extends Item.Builder {
        protected long size;
        protected ClaimType claimType = ClaimType.EXCLUSIVE;
        protected Set<String> readers = ImmutableSet.of();

        public Builder claimType(ClaimType claimType) {
            this.claimType = claimType;
            return this;
        }

        public Builder readers(Iterable<String> readers) {
            this.readers = ImmutableSet.copyOf(Preconditions.checkNotNull(readers, "readers"));
            return this;
        }

        public Builder size(long size) {
            this.size = size;
            return this;
        }

        @Override
        public Builder uuid(String uuid) {
            return (Builder)Builder.class.cast(super.uuid(uuid));
        }

        @Override
        public Builder name(String name) {
            return (Builder)Builder.class.cast(super.name(name));
        }

        @Override
        public Builder tags(Iterable<String> tags) {
            return (Builder)Builder.class.cast(super.tags(tags));
        }

        @Override
        public Builder userMetadata(Map<String, String> userMetadata) {
            return (Builder)Builder.class.cast(super.userMetadata(userMetadata));
        }

        @Override
        public Drive build() {
            return new Drive(this.uuid, this.name, this.size, this.claimType, this.readers, this.tags, this.userMetadata);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.claimType == null ? 0 : this.claimType.hashCode());
            result = 31 * result + (this.readers == null ? 0 : ((Object)this.readers).hashCode());
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Builder other = (Builder)obj;
            if (this.claimType != other.claimType) {
                return false;
            }
            if (this.readers == null ? other.readers != null : !((Object)this.readers).equals(other.readers)) {
                return false;
            }
            return this.size == other.size;
        }
    }
}

