/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.NoSuchElementException;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.logging.Logger;
import org.jclouds.rest.ResourceNotFoundException;

@Singleton
public class SecurityGroupPresent
implements Predicate<RegionAndName> {
    private final EC2Client client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public SecurityGroupPresent(EC2Client client) {
        this.client = Preconditions.checkNotNull(client, "client");
    }

    @Override
    public boolean apply(RegionAndName securityGroup) {
        this.logger.trace("looking for security group %s/%s", securityGroup.getRegion(), securityGroup.getName());
        try {
            return this.refresh(securityGroup) != null;
        }
        catch (ResourceNotFoundException e) {
            return false;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    protected SecurityGroup refresh(RegionAndName securityGroup) {
        return Iterables.getOnlyElement(this.client.getSecurityGroupServices().describeSecurityGroupsInRegion(securityGroup.getRegion(), securityGroup.getName()));
    }
}

