/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.cloudwatch.domain.Unit;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class GetMetricStatisticsOptions
extends BaseHttpRequestOptions {
    private Set<Dimension> dimensions;

    public GetMetricStatisticsOptions dimension(Dimension dimension) {
        if (this.dimensions == null) {
            this.dimensions = Sets.newLinkedHashSet();
        }
        this.dimensions.add(dimension);
        return this;
    }

    public GetMetricStatisticsOptions dimensions(Set<Dimension> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public GetMetricStatisticsOptions instanceId(String instanceId) {
        String[] parts = AWSUtils.parseHandle(instanceId);
        this.formParameters.put("Dimensions.member.1.Name", "InstanceId");
        this.formParameters.put("Dimensions.member.1.Value", Preconditions.checkNotNull(parts[1]));
        return this;
    }

    public GetMetricStatisticsOptions unit(Unit unit) {
        this.formParameters.put("Unit", unit.toString());
        return this;
    }

    @Override
    public Multimap<String, String> buildFormParameters() {
        Multimap<String, String> formParameters = super.buildFormParameters();
        int dimensionIndex = 1;
        if (this.dimensions != null) {
            for (Dimension dimension : this.dimensions) {
                formParameters.put("Dimensions.member." + dimensionIndex + ".Name", dimension.getName());
                formParameters.put("Dimensions.member." + dimensionIndex + ".Value", dimension.getValue());
                ++dimensionIndex;
            }
        }
        return formParameters;
    }

    public static class Builder {
        public static GetMetricStatisticsOptions instanceId(String instanceId) {
            GetMetricStatisticsOptions options = new GetMetricStatisticsOptions();
            return options.instanceId(instanceId);
        }

        public static GetMetricStatisticsOptions unit(Unit unit) {
            GetMetricStatisticsOptions options = new GetMetricStatisticsOptions();
            return options.unit(unit);
        }

        public static GetMetricStatisticsOptions dimension(Dimension dimension) {
            GetMetricStatisticsOptions options = new GetMetricStatisticsOptions();
            return options.dimension(dimension);
        }

        public static GetMetricStatisticsOptions dimensions(Set<Dimension> dimensions) {
            GetMetricStatisticsOptions options = new GetMetricStatisticsOptions();
            return options.dimensions(dimensions);
        }
    }
}

