/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.List;
import org.jclouds.cloudwatch.CloudWatchApi;
import org.jclouds.cloudwatch.domain.Metric;
import org.jclouds.cloudwatch.domain.MetricDatum;
import org.jclouds.cloudwatch.features.MetricApi;
import org.jclouds.cloudwatch.options.ListMetricsOptions;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterables;

public class CloudWatch {
    public static Iterable<Metric> listMetrics(final MetricApi metricApi, final ListMetricsOptions options) {
        return Iterables.concat(PagedIterables.advance(metricApi.list(options), new Function<Object, IterableWithMarker<Metric>>(){

            @Override
            public IterableWithMarker<Metric> apply(Object input) {
                return metricApi.list(options.clone().afterMarker(input));
            }

            public String toString() {
                return "listMetrics(" + options + ")";
            }
        }));
    }

    public static Iterable<Metric> listMetrics(CloudWatchApi cloudWatchApi, String region, ListMetricsOptions options) {
        return CloudWatch.listMetrics(cloudWatchApi.getMetricApiForRegion(region), options);
    }

    public static void putMetricData(CloudWatchApi cloudWatchApi, String region, Iterable<MetricDatum> metrics, String namespace) {
        MetricApi metricApi = cloudWatchApi.getMetricApiForRegion(region);
        for (List<MetricDatum> slice : Iterables.partition(metrics, 10)) {
            metricApi.putMetricsInNamespace(slice, namespace);
        }
    }
}

