/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.cloudstack.options.AccountInDomainOptions;

public class CreateLoadBalancerRuleOptions
extends AccountInDomainOptions {
    public static final CreateLoadBalancerRuleOptions NONE = new CreateLoadBalancerRuleOptions();

    public CreateLoadBalancerRuleOptions allowedSourceCIDRs(Set<String> allowedSourceCIRDs) {
        this.queryParameters.replaceValues("cidrlist", ImmutableSet.of(Joiner.on(",").join(allowedSourceCIRDs)));
        return this;
    }

    public CreateLoadBalancerRuleOptions description(String description) {
        this.queryParameters.replaceValues("description", ImmutableSet.of(description));
        return this;
    }

    public CreateLoadBalancerRuleOptions openFirewall(boolean openFirewall) {
        this.queryParameters.replaceValues("openfirewall", ImmutableSet.of(openFirewall + ""));
        return this;
    }

    public CreateLoadBalancerRuleOptions zoneId(String zoneId) {
        this.queryParameters.replaceValues("zoneid", ImmutableSet.of(zoneId + ""));
        return this;
    }

    @Override
    public CreateLoadBalancerRuleOptions accountInDomain(String account, String domain) {
        return (CreateLoadBalancerRuleOptions)CreateLoadBalancerRuleOptions.class.cast(super.accountInDomain(account, domain));
    }

    @Override
    public CreateLoadBalancerRuleOptions domainId(String domainId) {
        return (CreateLoadBalancerRuleOptions)CreateLoadBalancerRuleOptions.class.cast(super.domainId(domainId));
    }

    public static class Builder {
        public static CreateLoadBalancerRuleOptions allowedSourceCIDRs(Set<String> allowedSourceCIDRs) {
            CreateLoadBalancerRuleOptions options = new CreateLoadBalancerRuleOptions();
            return options.allowedSourceCIDRs(allowedSourceCIDRs);
        }

        public static CreateLoadBalancerRuleOptions description(String description) {
            CreateLoadBalancerRuleOptions options = new CreateLoadBalancerRuleOptions();
            return options.description(description);
        }

        public static CreateLoadBalancerRuleOptions openFirewall(boolean openFirewall) {
            CreateLoadBalancerRuleOptions options = new CreateLoadBalancerRuleOptions();
            return options.openFirewall(openFirewall);
        }

        public static CreateLoadBalancerRuleOptions zoneId(String zoneId) {
            CreateLoadBalancerRuleOptions options = new CreateLoadBalancerRuleOptions();
            return options.zoneId(zoneId);
        }

        public static CreateLoadBalancerRuleOptions accountInDomain(String account, String domain) {
            CreateLoadBalancerRuleOptions options = new CreateLoadBalancerRuleOptions();
            return options.accountInDomain(account, domain);
        }

        public static CreateLoadBalancerRuleOptions domainId(String id) {
            CreateLoadBalancerRuleOptions options = new CreateLoadBalancerRuleOptions();
            return options.domainId(id);
        }
    }
}

