/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class Flavor {
    private final int id;
    private final String name;
    private final Integer disk;
    private final Integer ram;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromFlavor(this);
    }

    @ConstructorProperties(value={"id", "name", "disk", "ram"})
    protected Flavor(int id, String name, @Nullable Integer disk, @Nullable Integer ram) {
        this.id = id;
        this.name = Preconditions.checkNotNull(name, "name");
        this.disk = disk;
        this.ram = ram;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public Integer getDisk() {
        return this.disk;
    }

    @Nullable
    public Integer getRam() {
        return this.ram;
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.name, this.disk, this.ram);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Flavor that = (Flavor)Flavor.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.name, that.name) && Objects.equal(this.disk, that.disk) && Objects.equal(this.ram, that.ram);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("id", this.id).add("name", this.name).add("disk", this.disk).add("ram", this.ram);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected int id;
        protected String name;
        protected Integer disk;
        protected Integer ram;

        protected abstract T self();

        public T id(int id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T disk(Integer disk) {
            this.disk = disk;
            return this.self();
        }

        public T ram(Integer ram) {
            this.ram = ram;
            return this.self();
        }

        public Flavor build() {
            return new Flavor(this.id, this.name, this.disk, this.ram);
        }

        public T fromFlavor(Flavor in) {
            return ((Builder)((Builder)((Builder)this.id(in.getId())).name(in.getName())).disk(in.getDisk())).ram(in.getRam());
        }
    }
}

