/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.config;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.Provides;
import java.net.URI;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.jclouds.cloudservers.CloudServersAsyncClient;
import org.jclouds.cloudservers.CloudServersClient;
import org.jclouds.cloudservers.handlers.ParseCloudServersErrorFromHttpResponse;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.json.config.GsonModule;
import org.jclouds.location.suppliers.RegionIdToURISupplier;
import org.jclouds.openstack.keystone.v1_1.config.AuthenticationServiceModule;
import org.jclouds.openstack.services.Compute;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.config.RestClientModule;
import org.jclouds.util.Suppliers2;

@ConfiguresRestClient
public class CloudServersRestClientModule
extends RestClientModule<CloudServersClient, CloudServersAsyncClient> {
    @Override
    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
        super.configure();
    }

    @Override
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseCloudServersErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseCloudServersErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseCloudServersErrorFromHttpResponse.class);
    }

    @Override
    protected void installLocations() {
        super.installLocations();
        this.install(new AuthenticationServiceModule());
    }

    @Provides
    @Singleton
    @Compute
    protected Supplier<URI> provideCloudServers(RegionIdToURISupplier.Factory factory, @ApiVersion String apiVersion) {
        return Suppliers2.getLastValueInMap(factory.createForApiTypeAndVersion("cloudServers", apiVersion));
    }

    @Provides
    @Singleton
    @TimeStamp
    protected Supplier<Date> provideCacheBusterDate() {
        return Suppliers.memoizeWithExpiration(new Supplier<Date>(){

            @Override
            public Date get() {
                return new Date();
            }
        }, 1L, TimeUnit.SECONDS);
    }
}

