/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudservers.domain.Server;
import org.jclouds.cloudservers.domain.ServerStatus;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.logging.Logger;

@Singleton
public class ServerToNodeMetadata
implements Function<Server, NodeMetadata> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final Supplier<Location> location;
    protected final Map<ServerStatus, NodeMetadata.Status> serverToNodeStatus;
    protected final Supplier<Set<? extends Image>> images;
    protected final Supplier<Set<? extends Hardware>> hardwares;
    protected final GroupNamingConvention nodeNamingConvention;

    @Inject
    ServerToNodeMetadata(Map<ServerStatus, NodeMetadata.Status> serverStateToNodeStatus, @Memoized Supplier<Set<? extends Image>> images, Supplier<Location> location, @Memoized Supplier<Set<? extends Hardware>> hardwares, GroupNamingConvention.Factory namingConvention) {
        this.nodeNamingConvention = Preconditions.checkNotNull(namingConvention, "namingConvention").createWithoutPrefix();
        this.serverToNodeStatus = Preconditions.checkNotNull(serverStateToNodeStatus, "serverStateToNodeStatus");
        this.images = Preconditions.checkNotNull(images, "images");
        this.location = Preconditions.checkNotNull(location, "location");
        this.hardwares = Preconditions.checkNotNull(hardwares, "hardwares");
    }

    @Override
    public NodeMetadata apply(Server from) {
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.getId() + "");
        builder.name(from.getName());
        builder.hostname(from.getName());
        builder.location(new LocationBuilder().scope(LocationScope.HOST).id(from.getHostId()).description(from.getHostId()).parent(this.location.get()).build());
        ComputeServiceUtils.addMetadataAndParseTagsFromCommaDelimitedValue(builder, from.getMetadata());
        builder.group(this.nodeNamingConvention.groupInUniqueNameOrNull(from.getName()));
        builder.imageId(from.getImageId() + "");
        builder.operatingSystem(this.parseOperatingSystem(from));
        builder.hardware(this.parseHardware(from));
        builder.status(this.serverToNodeStatus.get((Object)from.getStatus()));
        builder.publicAddresses(from.getAddresses().getPublicAddresses());
        builder.privateAddresses(from.getAddresses().getPrivateAddresses());
        return builder.build();
    }

    protected Hardware parseHardware(Server from) {
        try {
            return Iterables.find((Iterable)this.hardwares.get(), new FindHardwareForServer(from));
        }
        catch (NoSuchElementException e) {
            this.logger.debug("could not find a matching hardware for server %s", from);
            return null;
        }
    }

    protected OperatingSystem parseOperatingSystem(Server from) {
        try {
            return Iterables.find((Iterable)this.images.get(), new FindImageForServer(from)).getOperatingSystem();
        }
        catch (NoSuchElementException e) {
            this.logger.debug("could not find a matching image for server %s in location %s", from, this.location.get());
            return null;
        }
    }

    private static class FindHardwareForServer
    implements Predicate<Hardware> {
        private final Server instance;

        private FindHardwareForServer(Server instance) {
            this.instance = instance;
        }

        @Override
        public boolean apply(Hardware input) {
            return input.getProviderId().equals(this.instance.getFlavorId() + "");
        }
    }

    private static class FindImageForServer
    implements Predicate<Image> {
        private final Server instance;

        private FindImageForServer(Server instance) {
            this.instance = instance;
        }

        @Override
        public boolean apply(Image input) {
            return input.getProviderId().equals(this.instance.getImageId() + "");
        }
    }
}

