/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.binders.BindMapToHeadersWithPrefix;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;
import org.jclouds.s3.domain.ObjectMetadata;

@Singleton
public class BindObjectMetadataToRequest
implements Binder {
    protected final BindMapToHeadersWithPrefix metadataPrefixer;

    @Inject
    public BindObjectMetadataToRequest(BindMapToHeadersWithPrefix metadataPrefixer) {
        this.metadataPrefixer = Preconditions.checkNotNull(metadataPrefixer, "metadataPrefixer");
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof ObjectMetadata, "this binder is only valid for ObjectMetadata!");
        Preconditions.checkNotNull(request, "request");
        ObjectMetadata md = (ObjectMetadata)ObjectMetadata.class.cast(input);
        Preconditions.checkArgument(md.getKey() != null, "objectMetadata.getKey() must be set!");
        request = this.metadataPrefixer.bindToRequest(request, md.getUserMetadata());
        ImmutableMultimap.Builder<String, String> headers = ImmutableMultimap.builder();
        if (md.getCacheControl() != null) {
            headers.put("Cache-Control", md.getCacheControl());
        }
        if (md.getContentMetadata().getContentDisposition() != null) {
            headers.put("Content-Disposition", md.getContentMetadata().getContentDisposition());
        }
        if (md.getContentMetadata().getContentEncoding() != null) {
            headers.put("Content-Encoding", md.getContentMetadata().getContentEncoding());
        }
        if (md.getContentMetadata().getContentType() != null) {
            headers.put("Content-Type", md.getContentMetadata().getContentType());
        } else {
            headers.put("Content-Type", "binary/octet-stream");
        }
        if (md.getContentMetadata().getContentMD5() != null) {
            headers.put("Content-MD5", CryptoStreams.base64(md.getContentMetadata().getContentMD5()));
        }
        return (R)((HttpRequest.Builder)request.toBuilder().replaceHeaders(headers.build())).build();
    }
}

