/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.domain;

import java.util.Date;
import org.jclouds.atmos.domain.DirectoryEntry;
import org.jclouds.atmos.domain.FileType;
import org.jclouds.javax.annotation.Nullable;

public class SystemMetadata
extends DirectoryEntry {
    private final Date atime;
    private final Date ctime;
    private final String gid;
    private final Date itime;
    private final Date mtime;
    private final int nlink;
    private final String policyname;
    private final long size;
    private final String uid;
    private final byte[] contentmd5;

    public SystemMetadata(@Nullable byte[] contentmd5, Date atime, Date ctime, String gid, Date itime, Date mtime, int nlink, String objectid, String objname, String policyname, long size, FileType type, String uid) {
        super(objectid, type, objname);
        this.contentmd5 = contentmd5;
        this.atime = atime;
        this.ctime = ctime;
        this.gid = gid;
        this.itime = itime;
        this.mtime = mtime;
        this.nlink = nlink;
        this.policyname = policyname;
        this.size = size;
        this.uid = uid;
    }

    public String getGroupID() {
        return this.gid;
    }

    public int getHardLinkCount() {
        return this.nlink;
    }

    public Date getInceptionTime() {
        return this.itime;
    }

    public Date getLastAccessTime() {
        return this.atime;
    }

    public Date getLastMetadataModification() {
        return this.mtime;
    }

    public Date getLastUserDataModification() {
        return this.ctime;
    }

    public String getPolicyName() {
        return this.policyname;
    }

    public long getSize() {
        return this.size;
    }

    public String getUserID() {
        return this.uid;
    }

    public byte[] getContentMD5() {
        return this.contentmd5;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.atime == null ? 0 : this.atime.hashCode());
        result = 31 * result + (this.ctime == null ? 0 : this.ctime.hashCode());
        result = 31 * result + (this.gid == null ? 0 : this.gid.hashCode());
        result = 31 * result + (this.itime == null ? 0 : this.itime.hashCode());
        result = 31 * result + (this.mtime == null ? 0 : this.mtime.hashCode());
        result = 31 * result + this.nlink;
        result = 31 * result + (this.policyname == null ? 0 : this.policyname.hashCode());
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (this.uid == null ? 0 : this.uid.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SystemMetadata other = (SystemMetadata)obj;
        if (this.atime == null ? other.atime != null : !this.atime.equals(other.atime)) {
            return false;
        }
        if (this.ctime == null ? other.ctime != null : !this.ctime.equals(other.ctime)) {
            return false;
        }
        if (this.gid == null ? other.gid != null : !this.gid.equals(other.gid)) {
            return false;
        }
        if (this.itime == null ? other.itime != null : !this.itime.equals(other.itime)) {
            return false;
        }
        if (this.mtime == null ? other.mtime != null : !this.mtime.equals(other.mtime)) {
            return false;
        }
        if (this.nlink != other.nlink) {
            return false;
        }
        if (this.policyname == null ? other.policyname != null : !this.policyname.equals(other.policyname)) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        return !(this.uid == null ? other.uid != null : !this.uid.equals(other.uid));
    }

    @Override
    public String toString() {
        return "[type=" + (Object)((Object)this.getType()) + ", id=" + this.getObjectID() + ", name=" + this.getObjectName() + "]";
    }
}

