/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.xfer;

import java.util.ArrayList;
import java.util.List;
import net.schmizz.sshj.xfer.TransferListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingTransferListener
implements TransferListener {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<String> dirNames = new ArrayList<String>();
    private String base = "";
    private String name = "";
    private long size = -1L;

    @Override
    public void startedDir(String name) {
        this.dirNames.add(name);
        this.size = -1L;
        this.fixBase();
        this.log.info("started transferring directory `{}`", (Object)this.currentNode());
    }

    @Override
    public void startedFile(String name, long size) {
        this.name = name;
        this.size = size;
        this.log.info("started transferring file `{}` ({} bytes)", (Object)this.currentNode(), (Object)size);
    }

    @Override
    public void reportProgress(long transferred) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("transferred {}% of `{}`", transferred * 100L / this.size, (Object)this.currentNode());
        }
    }

    @Override
    public void finishedFile() {
        this.log.info("finished transferring file `{}`", (Object)this.currentNode());
        this.name = "";
        this.size = -1L;
    }

    @Override
    public void finishedDir() {
        this.log.info("finished transferring dir `{}`", (Object)this.currentNode());
        this.size = -1L;
        this.dirNames.remove(this.dirNames.size() - 1);
        this.fixBase();
    }

    private void fixBase() {
        StringBuilder qualifier = new StringBuilder();
        for (String parent : this.dirNames) {
            qualifier.append(parent).append("/");
        }
        this.base = qualifier.toString();
    }

    private String currentNode() {
        return this.base + this.name;
    }
}

